<?php
header('Content-Type: application/json');
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || !in_array($_SESSION['tipo'], ['adm', 'personal'])) {
    echo json_encode(['success' => false, 'message' => 'Acesso não autorizado']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);
if (!$data || !isset($data['id_aluno']) || !isset($data['dia_semana']) || !isset($data['nome_treino']) || !isset($data['exercicios'])) {
    echo json_encode(['success' => false, 'message' => 'Dados inválidos']);
    exit;
}

$id_aluno = (int)$data['id_aluno'];
$dia_semana = $data['dia_semana'];
$nome_treino = $data['nome_treino'];
$musculos_focados = $data['musculos_focados'];
$exercicios = $data['exercicios'];

$conexao->begin_transaction();
try {
    $stmt_inativar = $conexao->prepare("UPDATE treinos SET status = 'inativo' WHERE id_aluno = ? AND dia_semana = ?");
    $stmt_inativar->bind_param("is", $id_aluno, $dia_semana);
    $stmt_inativar->execute();
    $stmt_inativar->close();

    $stmt_treino = $conexao->prepare("INSERT INTO treinos (id_aluno, nome_treino, dia_semana, musculos_focados, status) VALUES (?, ?, ?, ?, 'ativo')");
    $stmt_treino->bind_param("isss", $id_aluno, $nome_treino, $dia_semana, $musculos_focados);
    $stmt_treino->execute();
    $id_treino_novo = $conexao->insert_id;
    $stmt_treino->close();

    $stmt_exercicio = $conexao->prepare("INSERT INTO treino_exercicios (id_treino, id_exercicio, series, repeticoes, carga_inicial) VALUES (?, ?, ?, ?, ?)");
    foreach ($exercicios as $ex) {
        $stmt_exercicio->bind_param("iissd", $id_treino_novo, $ex['id_exercicio'], $ex['series'], $ex['repeticoes'], $ex['carga_inicial']);
        $stmt_exercicio->execute();
    }
    $stmt_exercicio->close();

    $conexao->commit();
    echo json_encode(['success' => true, 'message' => 'Treino atribuído com sucesso!']);
} catch (mysqli_sql_exception $exception) {
    $conexao->rollback();
    echo json_encode(['success' => false, 'message' => $exception->getMessage()]);
}
$conexao->close();
?>