<?php
header('Content-Type: application/json');
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'personal' || !isset($_GET['aluno_id'])) {
    http_response_code(403); exit;
}
$id_personal = $_SESSION['id'];
$id_aluno = (int)$_GET['aluno_id'];
$check_stmt = $conexao->prepare("SELECT id FROM usuarios WHERE id = ? AND id_personal = ?");
$check_stmt->bind_param("ii", $id_aluno, $id_personal);
$check_stmt->execute();
if ($check_stmt->get_result()->num_rows === 0) {
    if ($_SESSION['tipo'] !== 'adm') {
        http_response_code(403); exit;
    }
}
$check_stmt->close();

$tipo_dado = $_GET['tipo'];
switch ($tipo_dado) {
    case 'evolucao_lista':
        $query = $conexao->prepare("SELECT DISTINCT e.id, e.nome_exercicio FROM exercicios e JOIN treino_exercicios te ON e.id = te.id_exercicio JOIN historico_treino ht ON te.id = ht.id_treino_exercicio WHERE ht.id_aluno = ? ORDER BY e.nome_exercicio");
        $query->bind_param("i", $id_aluno);
        break;
    case 'evolucao_dados':
        $id_exercicio = (int)$_GET['exercicio_id'];
        $query = $conexao->prepare("SELECT ht.data_checkin, ht.carga_utilizada FROM historico_treino ht JOIN treino_exercicios te ON ht.id_treino_exercicio = te.id WHERE ht.id_aluno = ? AND te.id_exercicio = ? ORDER BY ht.data_checkin ASC");
        $query->bind_param("ii", $id_aluno, $id_exercicio);
        break;
    default: http_response_code(400); exit;
}
$query->execute();
$result = $query->get_result();
$data = $result->fetch_all(MYSQLI_ASSOC);
echo json_encode($data);
$query->close();
$conexao->close();
?>