<?php
header('Content-Type: application/json');
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'personal') {
    echo json_encode(['success' => false, 'message' => 'Acesso não autorizado']);
    exit;
}
$data = json_decode(file_get_contents('php://input'), true);
if (!$data || !isset($data['modelo_id'])) {
    echo json_encode(['success' => false, 'message' => 'ID do modelo não fornecido']);
    exit;
}
$id_modelo = (int)$data['modelo_id'];
$id_personal = $_SESSION['id'];

// Verificação extra de segurança para garantir que o personal só apaga os seus próprios modelos
$stmt = $conexao->prepare("DELETE FROM treino_modelos WHERE id = ? AND id_personal = ?");
$stmt->bind_param("ii", $id_modelo, $id_personal);
if ($stmt->execute()) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => $stmt->error]);
}
$stmt->close();
$conexao->close();
?>