<?php
header('Content-Type: application/json');
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || !in_array($_SESSION['tipo'], ['adm', 'personal'])) {
    echo json_encode(['success' => false, 'message' => 'Acesso no autorizado']);
    exit;
}
$data = json_decode(file_get_contents('php://input'), true);
if (!$data || !isset($data['treino_id'])) {
    echo json_encode(['success' => false, 'message' => 'ID do treino no fornecido']);
    exit;
}
$id_treino = (int)$data['treino_id'];

$stmt = $conexao->prepare("DELETE FROM treinos WHERE id = ?");
$stmt->bind_param("i", $id_treino);
if ($stmt->execute()) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => $stmt->error]);
}
$stmt->close();
$conexao->close();
?>