<?php
header('Content-Type: application/json');
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || !in_array($_SESSION['tipo'], ['adm', 'personal']) || !isset($_GET['modelo_id'])) {
    http_response_code(403); exit;
}
$id_modelo = (int)$_GET['modelo_id'];

$modelo_info_stmt = $conexao->prepare("SELECT nome_modelo, musculos_focados FROM treino_modelos WHERE id = ?");
$modelo_info_stmt->bind_param("i", $id_modelo);
$modelo_info_stmt->execute();
$modelo_info = $modelo_info_stmt->get_result()->fetch_assoc();
$modelo_info_stmt->close();

$exercicios_stmt = $conexao->prepare("
    SELECT e.id as id_exercicio, e.nome_exercicio, tme.series, tme.repeticoes, tme.carga_sugerida
    FROM treino_modelo_exercicios tme
    JOIN exercicios e ON tme.id_exercicio = e.id
    WHERE tme.id_modelo = ?
");
$exercicios_stmt->bind_param("i", $id_modelo);
$exercicios_stmt->execute();
$exercicios = $exercicios_stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$exercicios_stmt->close();

echo json_encode(['info' => $modelo_info, 'exercicios' => $exercicios]);
?>