<?php
header('Content-Type: application/json');
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'personal') {
    http_response_code(403); exit;
}
$id_personal = $_SESSION['id'];

$modelos_query = $conexao->prepare("SELECT id, nome_modelo, musculos_focados FROM treino_modelos WHERE id_personal = ? ORDER BY nome_modelo");
$modelos_query->bind_param("i", $id_personal);
$modelos_query->execute();
$modelos = $modelos_query->get_result()->fetch_all(MYSQLI_ASSOC);
$modelos_query->close();

$response_data = [];
foreach ($modelos as $modelo) {
    $exercicios_query = $conexao->prepare("
        SELECT e.nome_exercicio, tme.series, tme.repeticoes, tme.carga_sugerida
        FROM treino_modelo_exercicios tme
        JOIN exercicios e ON tme.id_exercicio = e.id
        WHERE tme.id_modelo = ?
    ");
    $exercicios_query->bind_param("i", $modelo['id']);
    $exercicios_query->execute();
    $exercicios = $exercicios_query->get_result()->fetch_all(MYSQLI_ASSOC);
    $modelo['exercicios'] = $exercicios;
    $response_data[] = $modelo;
    $exercicios_query->close();
}

echo json_encode($response_data);
$conexao->close();
?>