<?php
header('Content-Type: application/json');
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || !isset($_GET['data'])) {
    http_response_code(403); exit;
}
$id_aluno = $_SESSION['id'];
$data_treino = $_GET['data'];

// Busca os detalhes dos exercícios realizados
$stmt_exercicios = $conexao->prepare("
    SELECT e.nome_exercicio, te.series, te.repeticoes, ht.carga_utilizada 
    FROM historico_treino ht
    JOIN treino_exercicios te ON ht.id_treino_exercicio = te.id
    JOIN exercicios e ON te.id_exercicio = e.id
    WHERE ht.id_aluno = ? AND ht.data_checkin = ?
");
$stmt_exercicios->bind_param("is", $id_aluno, $data_treino);
$stmt_exercicios->execute();
$exercicios = $stmt_exercicios->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt_exercicios->close();

// Busca a duração da sessão
$stmt_sessao = $conexao->prepare("
    SELECT TIME_FORMAT(TIMEDIFF(hora_fim, hora_inicio), '%H:%i:%s') as duracao
    FROM sessoes_treino 
    WHERE id_aluno = ? AND data_sessao = ?
");
$stmt_sessao->bind_param("is", $id_aluno, $data_treino);
$stmt_sessao->execute();
$sessao = $stmt_sessao->get_result()->fetch_assoc();
$stmt_sessao->close();

echo json_encode([
    'exercicios' => $exercicios,
    'duracao' => $sessao['duracao'] ?? null
]);
?>