<?php
header('Content-Type: application/json');
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || !in_array($_SESSION['tipo'], ['adm', 'personal']) || !isset($_GET['aluno_id'])) {
    http_response_code(403); exit;
}
$id_aluno = (int)$_GET['aluno_id'];

$treinos_query = $conexao->prepare("
    SELECT id, nome_treino, dia_semana, musculos_focados, status 
    FROM treinos 
    WHERE id_aluno = ? 
    ORDER BY FIELD(dia_semana, 'Segunda-feira', 'Ter04a-feira', 'Quarta-feira', 'Quinta-feira', 'Sexta-feira', 'Sbado', 'Domingo'), data_criacao DESC
");
$treinos_query->bind_param("i", $id_aluno);
$treinos_query->execute();
$treinos = $treinos_query->get_result()->fetch_all(MYSQLI_ASSOC);
$treinos_query->close();

$response_data = [];
foreach ($treinos as $treino) {
    $exercicios_query = $conexao->prepare("
        SELECT
            te.id,
            e.nome_exercicio,
            te.carga_inicial,
            (SELECT ht.carga_utilizada 
             FROM historico_treino ht 
             WHERE ht.id_treino_exercicio = te.id 
             ORDER BY ht.data_checkin DESC, ht.id DESC 
             LIMIT 1) as ultima_carga
        FROM treino_exercicios te
        JOIN exercicios e ON te.id_exercicio = e.id
        WHERE te.id_treino = ?
    ");
    $exercicios_query->bind_param("i", $treino['id']);
    $exercicios_query->execute();
    $exercicios = $exercicios_query->get_result()->fetch_all(MYSQLI_ASSOC);
    $treino['exercicios'] = $exercicios;
    $response_data[] = $treino;
    $exercicios_query->close();
}

echo json_encode($response_data);
$conexao->close();
?>