<?php
header('Content-Type: application/json');
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || !in_array($_SESSION['tipo'], ['adm', 'personal']) || !isset($_GET['aluno_id'])) {
    http_response_code(403); exit;
}
$id_aluno = (int)$_GET['aluno_id'];

$stmt = $conexao->prepare("SELECT dia_semana, nome_treino, musculos_focados FROM treinos WHERE id_aluno = ? AND status = 'ativo'");
$stmt->bind_param("i", $id_aluno);
$stmt->execute();
$result = $stmt->get_result();
$treinos_semana = [];
while ($row = $result->fetch_assoc()) {
    $treinos_semana[$row['dia_semana']] = $row['musculos_focados'] ?: $row['nome_treino'];
}
$stmt->close();

echo json_encode($treinos_semana);
?>