<?php
header('Content-Type: application/json');
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || !in_array($_SESSION['tipo'], ['adm', 'personal'])) {
    echo json_encode(['success' => false, 'message' => 'Acesso não autorizado']);
    exit;
}
$data = json_decode(file_get_contents('php://input'), true);
if (!$data || !isset($data['treino_id']) || !isset($data['status'])) {
    echo json_encode(['success' => false, 'message' => 'Dados inválidos']);
    exit;
}
$id_treino = (int)$data['treino_id'];
$status = $data['status'] === 'ativo' ? 'ativo' : 'inativo';

$stmt = $conexao->prepare("UPDATE treinos SET status = ? WHERE id = ?");
$stmt->bind_param("si", $status, $id_treino);
if ($stmt->execute()) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => $stmt->error]);
}
$stmt->close();
$conexao->close();
?>