<?php
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'personal') {
    header('Location: index.html'); exit;
}
$aluno_id = isset($_GET['aluno_id']) ? (int)$_GET['aluno_id'] : 0;
if ($aluno_id === 0) die("ID do aluno não fornecido.");

$aluno_stmt = $conexao->prepare("SELECT nome FROM usuarios WHERE id = ? AND id_personal = ?");
$aluno_stmt->bind_param("ii", $aluno_id, $_SESSION['id']);
$aluno_stmt->execute();
$aluno = $aluno_stmt->get_result()->fetch_assoc();
if (!$aluno) die("Aluno não encontrado ou não pertence a este personal.");

$avaliacao_stmt = $conexao->prepare("SELECT * FROM avaliacoes_fisicas WHERE id_aluno = ?");
$avaliacao_stmt->bind_param("i", $aluno_id);
$avaliacao_stmt->execute();
$avaliacao = $avaliacao_stmt->get_result()->fetch_assoc();
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Avaliação Física</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-900 text-white">
    <header class="bg-gray-800 p-4 flex justify-between items-center">
        <h1 class="text-xl font-bold">Avaliação Física de <?php echo htmlspecialchars($aluno['nome']); ?></h1>
        <a href="gerenciar_meus_alunos.php" class="bg-cyan-500 hover:bg-cyan-600 text-gray-900 font-bold py-2 px-4 rounded-lg">Voltar</a>
    </header>
    <main class="p-4">
        <form action="salvar_avaliacao.php" method="POST" class="bg-gray-800 p-6 rounded-lg space-y-4">
            <input type="hidden" name="id_aluno" value="<?php echo $aluno_id; ?>">
            
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label for="peso_atual" class="block mb-2">Peso Atual (kg)</label>
                    <input type="number" step="0.1" name="peso_atual" id="peso_atual" class="w-full bg-gray-700 rounded p-2" value="<?php echo htmlspecialchars($avaliacao['peso_atual'] ?? ''); ?>">
                </div>
                <div>
                    <label for="altura" class="block mb-2">Altura (m)</label>
                    <input type="number" step="0.01" name="altura" id="altura" class="w-full bg-gray-700 rounded p-2" value="<?php echo htmlspecialchars($avaliacao['altura'] ?? ''); ?>">
                </div>
                <div>
                    <label for="data_pesagem" class="block mb-2">Data da Pesagem</label>
                    <input type="date" name="data_pesagem" id="data_pesagem" class="w-full bg-gray-700 rounded p-2" value="<?php echo htmlspecialchars($avaliacao['data_pesagem'] ?? ''); ?>">
                </div>
            </div>

            <div>
                <label for="objetivo" class="block mb-2">Objetivo Principal</label>
                <input type="text" name="objetivo" id="objetivo" class="w-full bg-gray-700 rounded p-2" value="<?php echo htmlspecialchars($avaliacao['objetivo'] ?? ''); ?>">
            </div>
            <div>
                <label for="historico_lesoes" class="block mb-2">Histórico de Lesões</label>
                <textarea name="historico_lesoes" id="historico_lesoes" class="w-full bg-gray-700 rounded p-2" rows="3"><?php echo htmlspecialchars($avaliacao['historico_lesoes'] ?? ''); ?></textarea>
            </div>
            <div>
                <label for="medicamentos_uso" class="block mb-2">Medicamentos em Uso</label>
                <textarea name="medicamentos_uso" id="medicamentos_uso" class="w-full bg-gray-700 rounded p-2" rows="3"><?php echo htmlspecialchars($avaliacao['medicamentos_uso'] ?? ''); ?></textarea>
            </div>
            <div>
                <label for="frequencia_semanal" class="block mb-2">Frequência Semanal Desejada</label>
                <input type="number" name="frequencia_semanal" id="frequencia_semanal" class="w-full bg-gray-700 rounded p-2" value="<?php echo htmlspecialchars($avaliacao['frequencia_semanal'] ?? ''); ?>">
            </div>
            <div>
                <label for="observacoes" class="block mb-2">Observações Adicionais</label>
                <textarea name="observacoes" id="observacoes" class="w-full bg-gray-700 rounded p-2" rows="4"><?php echo htmlspecialchars($avaliacao['observacoes'] ?? ''); ?></textarea>
            </div>
            <button type="submit" class="w-full bg-green-500 hover:bg-green-600 text-white font-bold py-3 rounded-lg">Salvar Avaliação</button>
        </form>
    </main>
</body>
</html>