<?php
header('Content-Type: application/json');
require_once '../config.php';
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'aluno') {
    http_response_code(403); exit;
}

$duracao = isset($_GET['duracao']) ? (int)$_GET['duracao'] : 0;
$intensidade = isset($_GET['intensidade']) ? $_GET['intensidade'] : '';

if ($duracao === 0 || empty($intensidade)) {
    http_response_code(400); exit;
}

$stmt = $conexao->prepare("SELECT segmentos FROM cardio_hiit_protocolos WHERE duracao_total = ? AND intensidade = ?");
$stmt->bind_param("is", $duracao, $intensidade);
$stmt->execute();
$result = $stmt->get_result()->fetch_assoc();

if ($result) {
    echo $result['segmentos'];
} else {
    echo json_encode([]);
}
$stmt->close();
?>