<?php
require_once '../config.php';
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'aluno') {
    header('Location: ../index.html'); exit;
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cardio Livre</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body class="bg-gray-900 text-white flex flex-col h-screen">
    
    <header class="bg-white shadow-md p-4 flex justify-between items-center">
        <h1 class="text-1xl font-bold text-black">Olá, <?php echo htmlspecialchars(explode(' ', $_SESSION['nome'])[0]); ?>, Bora de cardio.</h1>
        <a href="javascript:history.back()" class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded-lg">Voltar</a>
    </header>
    
    <main class="flex-1 flex flex-col items-center justify-center p-4">
        <div id="cronometro-display" class="text-6xl font-mono mb-8">00:00:00</div>
        <div id="botoes-container" class="flex gap-4">
            <button id="start-btn" class="bg-green-500 hover:bg-green-600 text-white font-bold py-4 px-8 rounded-lg text-xl">
                <i class="fas fa-play"></i> Iniciar
            </button>
            <button id="pause-btn" class="bg-yellow-500 hover:bg-yellow-600 text-white font-bold py-4 px-8 rounded-lg text-xl hidden">
                <i class="fas fa-pause"></i> Pausar
            </button>
            <button id="end-btn" class="bg-red-500 hover:bg-red-600 text-white font-bold py-4 px-8 rounded-lg text-xl hidden">
                <i class="fas fa-stop"></i> Encerrar
            </button>
        </div>
    </main>
    <div id="confirm-modal" class="fixed inset-0 bg-black bg-opacity-75 flex items-center justify-center hidden z-50 p-4">
        <div class="bg-gray-700 p-8 rounded-lg text-center w-full max-w-sm">
            <h3 class="text-xl font-bold mb-4">Encerrar Cardio</h3>
            <p class="mb-4">Deseja salvar esta sessão de cardio?</p>
            <div class="mb-4">
                <label for="velocidade-media" class="block mb-2 text-sm font-medium">Velocidade Média (km/h)</label>
                <input type="number" step="0.1" id="velocidade-media" class="bg-gray-600 border border-gray-500 text-white text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" placeholder="Ex: 6.5">
            </div>
            <div class="flex justify-center gap-4">
                <button id="confirm-yes" class="bg-green-500 hover:bg-green-600 text-white font-bold py-2 px-6 rounded-lg">Sim, salvar</button>
                <button id="confirm-no" class="bg-red-500 hover:bg-red-600 text-white font-bold py-2 px-6 rounded-lg">Não, descartar</button>
            </div>
        </div>
    </div>
    <nav class="fixed bottom-0 left-0 right-0 bg-white border-t border-gray-200 flex justify-around p-4">
        <a href="dashboard_aluno.php" class="flex flex-col items-center text-gray-400 hover:text-indigo-400 w-1/3"><i class="fas fa-home fa-lg"></i><span class="text-xs mt-3">Início</span></a>
        <a href="treino_do_dia.php" class="flex flex-col items-center text-gray-400 hover:text-indigo-400 w-1/3"><i class="fas fa-dumbbell fa-lg"></i><span class="text-xs mt-3">Treino</span></a>
        <a href="perfil_aluno.php" class="flex flex-col items-center text-indigo-400 w-1/3"><i class="fas fa-user fa-lg"></i><span class="text-xs mt-3">Perfil</span></a>
    </nav>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const startBtn = document.getElementById('start-btn');
    const pauseBtn = document.getElementById('pause-btn');
    const endBtn = document.getElementById('end-btn');
    const display = document.getElementById('cronometro-display');
    const modal = document.getElementById('confirm-modal');
    const confirmYes = document.getElementById('confirm-yes');
    const confirmNo = document.getElementById('confirm-no');
    const velocidadeMediaInput = document.getElementById('velocidade-media');

    let segundos = 0;
    let intervalo;
    let isPaused = false;

    function formatarTempo(s) {
        return new Date(s * 1000).toISOString().substr(11, 8);
    }

    startBtn.addEventListener('click', () => {
        startBtn.classList.add('hidden');
        pauseBtn.classList.remove('hidden');
        endBtn.classList.remove('hidden');
        intervalo = setInterval(() => {
            if (!isPaused) {
                segundos++;
                display.textContent = formatarTempo(segundos);
            }
        }, 1000);
    });

    pauseBtn.addEventListener('click', () => {
        isPaused = !isPaused;
        if (isPaused) {
            pauseBtn.innerHTML = '<i class="fas fa-play"></i> Retomar';
            pauseBtn.classList.replace('bg-yellow-500', 'bg-blue-500');
            pauseBtn.classList.replace('hover:bg-yellow-600', 'hover:bg-blue-600');
        } else {
            pauseBtn.innerHTML = '<i class="fas fa-pause"></i> Pausar';
            pauseBtn.classList.replace('bg-blue-500', 'bg-yellow-500');
            pauseBtn.classList.replace('hover:bg-blue-600', 'hover:bg-yellow-600');
        }
    });

    endBtn.addEventListener('click', () => {
        isPaused = true;
        modal.classList.remove('hidden');
    });

    confirmNo.addEventListener('click', () => {
        window.location.href = '../perfil_aluno.php';
    });

    confirmYes.addEventListener('click', async () => {
        const duracao = formatarTempo(segundos);
        const velocidadeMedia = parseFloat(velocidadeMediaInput.value) || 0;
        const distancia = (velocidadeMedia * (segundos / 3600)).toFixed(2);

        await fetch('salvar_cardio_livre.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ duracao: duracao, distancia: distancia })
        });
        window.location.href = '../perfil_aluno.php';
    });
});
</script>
</body>
</html>