<?php
// Todo o seu cdigo PHP do incio do arquivo permanece exatamente o mesmo.
// Vou omiti-lo aqui para focar nas mudan04as do HTML.
require_once '../config.php';
header('Content-Type: text/html; charset=UTF-8');
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'aluno') {
    header('Location: ../index.html'); exit;
}
$id_aluno = $_SESSION['id'];

// --- Lgicas de busca no banco ---
$hiit_stmt = $conexao->prepare("SELECT * FROM cardio_hiit_historico WHERE id_aluno = ?");
$hiit_stmt->bind_param("i", $id_aluno);
$hiit_stmt->execute();
$historico_hiit = $hiit_stmt->get_result()->fetch_all(MYSQLI_ASSOC);

$livre_stmt = $conexao->prepare("SELECT * FROM cardio_livre_historico WHERE id_aluno = ?");
$livre_stmt->bind_param("i", $id_aluno);
$livre_stmt->execute();
$historico_livre = $livre_stmt->get_result()->fetch_all(MYSQLI_ASSOC);

// --- Lgicas de Totaliza0400o ---
function duracaoParaSegundos($tempo_str) {
    $partes = explode(':', $tempo_str);
    if (count($partes) == 3) return ($partes[0] * 3600) + ($partes[1] * 60) + $partes[2];
    if (count($partes) == 2) return ($partes[0] * 60) + $partes[1];
    return (int)$tempo_str;
}

function segundosParaDuracao($total_segundos) {
    $horas = floor($total_segundos / 3600);
    $minutos = floor(($total_segundos % 3600) / 60);
    $segundos = $total_segundos % 60;
    return sprintf('%02d:%02d:%02d', $horas, $minutos, $segundos);
}

// HIIT
$dias_hiit_unicos = count(array_unique(array_column($historico_hiit, 'data_cardio')));
$distancia_total_hiit = array_sum(array_column($historico_hiit, 'distancia_km'));
$segundos_totais_hiit = array_reduce($historico_hiit, fn($c, $i) => $c + duracaoParaSegundos($i['duracao_total']), 0);
$duracao_total_hiit_formatada = segundosParaDuracao($segundos_totais_hiit);

// Livre
$dias_livre_unicos = count(array_unique(array_column($historico_livre, 'data_cardio')));
$distancia_total_livre = array_sum(array_column($historico_livre, 'distancia_km'));
$segundos_totais_livre = array_reduce($historico_livre, fn($c, $i) => $c + duracaoParaSegundos($i['duracao_total']), 0);
$duracao_total_livre_formatada = segundosParaDuracao($segundos_totais_livre);

// --- Lgica para agrupar treinos por dia ---
$todos_os_treinos_com_tipo = array_merge(
    array_map(function($item) { $item['tipo'] = 'HIIT'; return $item; }, $historico_hiit),
    array_map(function($item) { $item['tipo'] = 'Livre'; return $item; }, $historico_livre)
);
$treinos_por_dia = [];
foreach ($todos_os_treinos_com_tipo as $treino) {
    $data = $treino['data_cardio'];
    if (!isset($treinos_por_dia[$data])) $treinos_por_dia[$data] = [];
    $treinos_por_dia[$data][] = $treino;
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0"> <title>Histrico de Cardio</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        /* ... Estilos sem altera0401es ... */
    </style>
</head>
<body class="bg-gray-900 text-white pb-20">
    <header class="bg-gray-800 p-4 shadow-lg">
        <h1 class="text-xl md:text-2xl font-bold text-center">Histrico de Cardio</h1>
    </header>

    <main class="container mx-auto p-4 space-y-6">
        <div class="grid grid-cols-2 md:grid-cols-2 gap-4">
            <div class="bg-gray-800 p-4 rounded-lg text-center space-y-2">
                <p class="text-lg font-bold text-indigo-400">Cardio HIIT</p>
                <div>
                    <p class="text-3xl font-bold"><?php echo $dias_hiit_unicos; ?></p>
                    <p class="text-sm text-gray-400">Dias de Treino</p>
                </div>
                <div class="border-t border-gray-700 pt-2 text-left text-base space-y-1">
                    <p class="text-gray-300"><i class="fas fa-road fa-fw mr-2 text-gray-500"></i>Dist09ncia: <span class="font-bold float-right"><?php echo number_format($distancia_total_hiit, 2, ',', '.'); ?> km</span></p>
                    <p class="text-gray-300"><i class="fas fa-clock fa-fw mr-2 text-gray-500"></i>Tempo: <span class="font-bold float-right"><?php echo $duracao_total_hiit_formatada; ?></span></p>
                </div>
            </div>
            <div class="bg-gray-800 p-4 rounded-lg text-center space-y-2">
                <p class="text-lg font-bold text-teal-400">Cardio Livre</p>
                 <div>
                    <p class="text-3xl font-bold"><?php echo $dias_livre_unicos; ?></p>
                    <p class="text-sm text-gray-400">Dias de Treino</p>
                </div>
                <div class="border-t border-gray-700 pt-2 text-left text-base space-y-1">
                     <p class="text-gray-300"><i class="fas fa-road fa-fw mr-2 text-gray-500"></i>Dist09ncia: <span class="font-bold float-right"><?php echo number_format($distancia_total_livre, 2, ',', '.'); ?> km</span></p>
                    <p class="text-gray-300"><i class="fas fa-clock fa-fw mr-2 text-gray-500"></i>Tempo: <span class="font-bold float-right"><?php echo $duracao_total_livre_formatada; ?></span></p>
                </div>
            </div>
        </div>

        <div id="date-scroller" class="overflow-x-auto bg-gray-800 p-2 rounded-lg">
            <div id="date-chips-container" class="flex space-x-2">
                </div>
        </div>

        <div id="detalhes-dia" class="bg-gray-800 p-4 md:p-6 rounded-lg min-h-[150px]">
            <h2 id="detalhes-titulo" class="text-lg md:text-xl font-bold mb-4"></h2>
            <div id="detalhes-conteudo" class="space-y-3"></div>
        </div>
    </main>

    <nav class="fixed bottom-0 left-0 right-0 bg-gray-800 border-t border-gray-700 flex justify-around p-4">
        <a href="../dashboard_aluno.php" class="flex flex-col items-center text-gray-400 hover:text-indigo-400 w-1/3">
            <i class="fas fa-home fa-lg"></i>
            <span class="text-xs mt-3">Incio</span>
        </a>
        <a href="../treino_do_dia.php" class="flex flex-col items-center text-gray-400 hover:text-indigo-400 w-1/3">
            <i class="fas fa-dumbbell fa-lg"></i>
            <span class="text-xs mt-3">Treino</span>
        </a>
        <a href="../perfil_aluno.php" class="flex flex-col items-center text-indigo-400 w-1/3">
            <i class="fas fa-user fa-lg"></i>
            <span class="text-xs mt-3">Perfil</span>
        </a>
    </nav>

<script>
    // O JAVASCRIPT 07 EXATAMENTE O MESMO DA VERS01O ANTERIOR
    // Nenhuma altera0400o necessria aqui.
    document.addEventListener('DOMContentLoaded', () => {
        const treinosPorDia = <?php echo json_encode($treinos_por_dia); ?>;
        const container = document.getElementById('date-chips-container');
        const detalhesTitulo = document.getElementById('detalhes-titulo');
        const detalhesConteudo = document.getElementById('detalhes-conteudo');

        const hoje = new Date();
        hoje.setHours(0, 0, 0, 0); 
        const hojeStr = hoje.toISOString().split('T')[0];

        const datasComTreino = Object.keys(treinosPorDia);
        let dataInicial = new Date(hoje);

        if (datasComTreino.length > 0) {
            const primeiraData = new Date(datasComTreino.sort()[0] + 'T00:00:00');
            dataInicial = primeiraData;
        } else {
            dataInicial.setDate(hoje.getDate() - 6);
        }
        
        for (let d = new Date(dataInicial); d <= hoje; d.setDate(d.getDate() + 1)) {
            const dataISO = d.toISOString().split('T')[0];
            const diaSemana = d.toLocaleDateString('pt-BR', { weekday: 'short' });
            const diaMes = d.toLocaleDateString('pt-BR', { day: '2-digit', month: '2-digit' });

            const chip = document.createElement('button');
            chip.className = 'date-chip relative p-3 w-20 bg-gray-700 rounded-lg text-center cursor-pointer transition';
            chip.innerHTML = `<span class="font-bold block">${diaSemana}</span><span class="text-sm">${diaMes}</span>`;

            if (treinosPorDia[dataISO]) {
                chip.classList.add('has-workout');
            }

            chip.addEventListener('click', () => {
                const chipSelecionadoAnterior = container.querySelector('.selected');
                if (chipSelecionadoAnterior) chipSelecionadoAnterior.classList.remove('selected');
                chip.classList.add('selected');
                mostrarDetalhes(dataISO);
            });

            container.appendChild(chip);
        }

        function mostrarDetalhes(data) {
            const treinosDoDia = treinosPorDia[data] || [];
            const dataObj = new Date(data + 'T00:00:00');
            const dataFormatada = dataObj.toLocaleDateString('pt-BR', {dateStyle: 'full'});

            detalhesTitulo.textContent = dataFormatada.charAt(0).toUpperCase() + dataFormatada.slice(1);
            detalhesConteudo.innerHTML = '';

            if (treinosDoDia.length > 0) {
                treinosDoDia.forEach(treino => {
                    const divTreino = document.createElement('div');
                    // MUDAN05A AQUI: Ajuste no padding e flex-wrap para telas pequenas
                    divTreino.className = 'bg-gray-700 p-3 rounded-lg flex flex-wrap justify-between items-center';
                    let infoPrincipal = `<strong class="${treino.tipo === 'HIIT' ? 'text-indigo-400' : 'text-teal-400'}">${treino.tipo}</strong>`;
                    if(treino.tipo === 'HIIT') infoPrincipal += ` - ${treino.protocolo_info}`;
                    divTreino.innerHTML = `
                        <span class="text-sm md:text-base mb-1 md:mb-0">${infoPrincipal}</span>
                        <span class="text-sm md:text-base text-right font-mono">${treino.duracao_total} | ${treino.distancia_km} km</span>
                    `;
                    detalhesConteudo.appendChild(divTreino);
                });
            } else {
                detalhesConteudo.innerHTML = '<p class="text-gray-400 text-center">Nenhum treino registado para este dia.</p>';
            }
        }

        function selecionarDiaInicial() {
            const chipDeHoje = container.querySelector(`[data-date="${hojeStr}"]`);
            if (chipDeHoje) {
                chipDeHoje.click();
                chipDeHoje.scrollIntoView({ behavior: 'smooth', inline: 'center', block: 'nearest' });
            } else {
                const ultimoChip = container.lastElementChild;
                if (ultimoChip) {
                    ultimoChip.click();
                    ultimoChip.scrollIntoView({ behavior: 'smooth', inline: 'center', block: 'nearest' });
                } else {
                    mostrarDetalhes(hojeStr);
                }
            }
        }
        selecionarDiaInicial();
    });
</script>
</body>
</html>