<?php
header('Content-Type: application/json');
require_once '../config.php';
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'aluno') {
    http_response_code(403); exit;
}
$data = json_decode(file_get_contents('php://input'), true);
if (!$data || !isset($data['duracao']) || !isset($data['distancia'])) {
    http_response_code(400); exit;
}

$id_aluno = $_SESSION['id'];
$duracao = $data['duracao'];
$distancia = $data['distancia'];
$data_cardio = date('Y-m-d');

$stmt = $conexao->prepare("INSERT INTO cardio_livre_historico (id_aluno, data_cardio, duracao_total, distancia_km) VALUES (?, ?, ?, ?)");
$stmt->bind_param("isss", $id_aluno, $data_cardio, $duracao, $distancia);
$stmt->execute();
$stmt->close();
echo json_encode(['success' => true]);
?>