<?php
header('Content-Type: application/json');
require_once '../config.php';
if (!isset($_SESSION['loggedin'])) { http_response_code(403); exit; }

$data = json_decode(file_get_contents('php://input'), true);
if (!$data || !isset($data['destinatario_id']) || !isset($data['mensagem'])) { http_response_code(400); exit; }

$id_remetente = $_SESSION['id'];
$id_destinatario = (int)$data['destinatario_id'];
$mensagem = trim($data['mensagem']);

if (empty($mensagem)) {
    echo json_encode(['success' => false, 'message' => 'A mensagem não pode estar vazia.']);
    exit;
}

$stmt = $conexao->prepare("INSERT INTO mensagens (id_remetente, id_destinatario, mensagem) VALUES (?, ?, ?)");
$stmt->bind_param("iis", $id_remetente, $id_destinatario, $mensagem);
if ($stmt->execute()) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => $stmt->error]);
}
?>