<?php
header('Content-Type: application/json');
require_once '../config.php';
if (!isset($_SESSION['loggedin']) || !isset($_GET['outro_usuario_id'])) { http_response_code(403); exit; }

$id_usuario_logado = $_SESSION['id'];
$id_outro_usuario = (int)$_GET['outro_usuario_id'];

// Marca as mensagens como lidas
$update_stmt = $conexao->prepare("UPDATE mensagens SET lida = TRUE WHERE id_remetente = ? AND id_destinatario = ?");
$update_stmt->bind_param("ii", $id_outro_usuario, $id_usuario_logado);
$update_stmt->execute();
$update_stmt->close();

// Busca a conversa
$stmt = $conexao->prepare("
    SELECT m.*, u.nome as nome_remetente, DATE_FORMAT(m.data_envio, '%d/%m %H:%i') as data_formatada
    FROM mensagens m
    JOIN usuarios u ON m.id_remetente = u.id
    WHERE (m.id_remetente = ? AND m.id_destinatario = ?) OR (m.id_remetente = ? AND m.id_destinatario = ?) 
    ORDER BY m.data_envio ASC
");
$stmt->bind_param("iiii", $id_usuario_logado, $id_outro_usuario, $id_outro_usuario, $id_usuario_logado);
$stmt->execute();
$mensagens = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

echo json_encode(['mensagens' => $mensagens, 'id_logado' => $id_usuario_logado]);
?>