<?php
require_once '../config.php';
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'aluno') {
    header('Location: ../index.html'); exit;
}
$id_aluno = $_SESSION['id'];
$personal_stmt = $conexao->prepare("SELECT p.id, p.nome FROM usuarios a JOIN usuarios p ON a.id_personal = p.id WHERE a.id = ?");
$personal_stmt->bind_param("i", $id_aluno);
$personal_stmt->execute();
$personal = $personal_stmt->get_result()->fetch_assoc();
if (!$personal) { die("Voc n00o tem um personal associado."); }
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chat com Personal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/tone/14.7.77/Tone.js"></script>
</head>
<body class="bg-gray-900 text-white flex flex-col h-screen">
    <header class="bg-gray-800 p-4 flex justify-between items-center flex-shrink-0">
        <h1 class="text-xl font-bold">Chat com <?php echo htmlspecialchars($personal['nome']); ?></h1>
        <div>
            <button id="mute-btn" class="text-white mr-4"><i class="fas fa-volume-up"></i></button>
            <a href="../dashboard_aluno.php" class="bg-cyan-500 hover:bg-cyan-600 text-gray-900 font-bold py-2 px-4 rounded-lg">Voltar</a>
        </div>
    </header>
    <main class="flex-1 flex flex-col overflow-hidden">
        <div id="chat-window" class="flex-1 p-4 flex flex-col gap-4 overflow-y-auto"></div>
        <form id="chat-form" class="flex gap-4 p-4 flex-shrink-0">
            <input type="hidden" id="destinatario-id" value="<?php echo $personal['id']; ?>">
            <input type="text" id="mensagem-input" class="flex-1 bg-gray-600 rounded-lg p-3" placeholder="Digite sua mensagem...">
            <button type="submit" class="bg-green-500 hover:bg-green-600 font-bold py-3 px-5 rounded-lg"><i class="fas fa-paper-plane"></i></button>
        </form>
    </main>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const chatWindow = document.getElementById('chat-window');
    const chatForm = document.getElementById('chat-form');
    const mensagemInput = document.getElementById('mensagem-input');
    const destinatarioId = document.getElementById('destinatario-id').value;
    const muteBtn = document.getElementById('mute-btn');
    let totalMensagensAtual = 0;
    const synth = new Tone.Synth().toDestination();
    let isMuted = false;

    async function carregarMensagens() {
        const response = await fetch(`api_get_conversa.php?outro_usuario_id=${destinatarioId}`);
        const data = await response.json();

        if (data.mensagens.length > totalMensagensAtual && totalMensagensAtual > 0) {
            const ultimaMsg = data.mensagens[data.mensagens.length - 1];
            if (ultimaMsg.id_remetente != data.id_logado && !isMuted) {
                synth.triggerAttackRelease("C5", "8n");
            }
        }
        totalMensagensAtual = data.mensagens.length;

        chatWindow.innerHTML = '';
        data.mensagens.forEach(msg => {
            const alinhamento = msg.id_remetente == data.id_logado ? 'items-end' : 'items-start';
            const corBalao = msg.id_remetente == data.id_logado ? 'bg-cyan-800' : 'bg-gray-600';
            chatWindow.innerHTML += `
                <div class="w-full flex flex-col ${alinhamento}">
                    <div class="p-3 rounded-lg max-w-xs ${corBalao}">
                        <p class="font-bold text-sm">${msg.nome_remetente}</p>
                        <p>${msg.mensagem}</p>
                        <p class="text-xs text-gray-400 text-right mt-1">${msg.data_formatada}</p>
                    </div>
                </div>
            `;
        });
        chatWindow.scrollTop = chatWindow.scrollHeight;
    }

    chatForm.addEventListener('submit', async function(e) {
        e.preventDefault();
        const mensagem = mensagemInput.value.trim();
        if (!mensagem) return;

        await fetch('api_enviar_mensagem.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ destinatario_id: destinatarioId, mensagem: mensagem })
        });
        mensagemInput.value = '';
        carregarMensagens();
    });

    muteBtn.addEventListener('click', function() {
        isMuted = !isMuted;
        this.innerHTML = isMuted ? '<i class="fas fa-volume-mute"></i>' : '<i class="fas fa-volume-up"></i>';
    });

    carregarMensagens();
    setInterval(carregarMensagens, 3000);
});
</script>
</body>
</html>