<?php
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'aluno') {
    header('Location: index.html'); exit;
}
$id_aluno = $_SESSION['id'];

$stmt = $conexao->prepare("
    SELECT c.nome, c.descricao, c.icone_fa, (ac.id_aluno IS NOT NULL) as desbloqueada
    FROM conquistas c
    LEFT JOIN aluno_conquistas ac ON c.id = ac.id_conquista AND ac.id_aluno = ?
    ORDER BY c.id
");
$stmt->bind_param("i", $id_aluno);
$stmt->execute();
$conquistas = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Minhas Conquistas</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body class="bg-gray-900 text-white">
    <header class="bg-gray-800 p-4 flex justify-between items-center">
        <h1 class="text-xl font-bold">Minhas Conquistas</h1>
        <a href="dashboard_aluno.php" class="bg-cyan-500 hover:bg-cyan-600 text-gray-900 font-bold py-2 px-4 rounded-lg">Voltar</a>
    </header>
    <main class="p-4">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <?php foreach ($conquistas as $conquista): ?>
                <div class="bg-gray-800 p-6 rounded-lg text-center transition-opacity <?php echo $conquista['desbloqueada'] ? 'opacity-100' : 'opacity-40'; ?>">
                    <i class="fas <?php echo $conquista['icone_fa']; ?> fa-4x mb-4 <?php echo $conquista['desbloqueada'] ? 'text-yellow-400' : 'text-gray-500'; ?>"></i>
                    <h3 class="text-xl font-bold"><?php echo htmlspecialchars($conquista['nome']); ?></h3>
                    <p class="text-gray-400 mt-2"><?php echo htmlspecialchars($conquista['descricao']); ?></p>
                </div>
            <?php endforeach; ?>
        </div>
    </main>
</body>
</html>