<?php
require_once 'config.php';
error_reporting(E_ALL);
ini_set('display_errors', 1);
// Busca todos os músculos distintos
$musculos = [];
$queryMusculos = $conexao->$conexao->query("SELECT * FROM grupos_musculares ORDER BY nome");
if ($queryMusculos) {
    while ($row = $queryMusculos->fetch_assoc()) {
        $musculos[] = $row['musculo'];
    }
}

// Busca todos os exercícios
$exercicios = [];
$queryExercicios = $conexao->query("SELECT id, nome, musculo FROM exercicios ORDER BY musculo, nome ASC");
if ($queryExercicios) {
    while ($row = $queryExercicios->fetch_assoc()) {
        $exercicios[] = $row;
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Criar Novo Modelo de Treino</title>
    <style>
        body { background-color: #0f0f0f; color: #fff; font-family: Arial, sans-serif; margin:0; padding:0;}
        h1 { text-align: center; padding:20px; color:#ffcc00;}
        .container { display: flex; padding:20px; gap:20px; }
        .box { background:#1a1a2e; padding:15px; border-radius:10px; flex:1; box-shadow:0 0 10px rgba(0,0,0,0.5);}
        h2 { margin-top:0; color:#66ff66;}
        .exercicio { padding:10px; margin:5px 0; background:#222; border-radius:6px; cursor:grab;}
        .dropzone { min-height:200px; border:2px dashed #555; padding:10px; border-radius:10px;}
        .dropzone .exercicio { background:#2c3e50;}
        select, input { width:100%; padding:8px; margin:5px 0 15px; border-radius:5px; border:none;}
        button { width:100%; padding:12px; background:#27ae60; color:white; border:none; border-radius:8px; cursor:pointer; font-size:16px;}
        button:hover { background:#2ecc71;}
    </style>
</head>
<body>

<h1>💪 Criar Novo Modelo de Treino</h1>

<div class="container">

    <!-- Biblioteca -->
    <div class="box">
        <h2>📚 Biblioteca de Exercícios</h2>
        <label for="musculo">Filtrar por músculo:</label>
        <select id="musculo" onchange="filtrarExercicios()">
            <option value="todos">Todos</option>
            <?php foreach ($musculos as $m): ?>
                <option value="<?php echo $m; ?>"><?php echo $m; ?></option>
            <?php endforeach; ?>
        </select>
        <div id="listaExercicios">
            <?php foreach ($exercicios as $ex): ?>
                <div class="exercicio" draggable="true" data-id="<?php echo $ex['id']; ?>" data-musculo="<?php echo $ex['musculo']; ?>">
                    <?php echo $ex['nome']; ?> (<?php echo $ex['musculo']; ?>)
                </div>
            <?php endforeach; ?>
        </div>
    </div>

    <!-- Criar Treino -->
    <div class="box">
        <h2>📝 Novo Treino</h2>
        <input type="text" id="nomeModelo" placeholder="Nome do Treino (Ex: Peito e Tríceps)">
        <div class="dropzone" id="dropzone">
            Arraste os exercícios aqui...
        </div>
        <button onclick="salvarTreino()">Salvar Treino</button>
    </div>

</div>

<script>
    // Drag & Drop
    const exercicios = document.querySelectorAll(".exercicio");
    const dropzone = document.getElementById("dropzone");

    exercicios.forEach(ex => {
        ex.addEventListener("dragstart", e => {
            e.dataTransfer.setData("id", ex.dataset.id);
            e.dataTransfer.setData("nome", ex.innerText);
        });
    });

    dropzone.addEventListener("dragover", e => e.preventDefault());

    dropzone.addEventListener("drop", e => {
        e.preventDefault();
        const id = e.dataTransfer.getData("id");
        const nome = e.dataTransfer.getData("nome");

        const novo = document.createElement("div");
        novo.classList.add("exercicio");
        novo.textContent = nome + " - Séries: __  Reps: __  Carga: __";
        novo.dataset.id = id;
        dropzone.appendChild(novo);
    });

    // Filtrar por músculo
    function filtrarExercicios() {
        const filtro = document.getElementById("musculo").value;
        document.querySelectorAll("#listaExercicios .exercicio").forEach(ex => {
            if (filtro === "todos" || ex.dataset.musculo === filtro) {
                ex.style.display = "block";
            } else {
                ex.style.display = "none";
            }
        });
    }

    // Salvar Treino (mockup AJAX futuramente)
    function salvarTreino() {
        let nomeTreino = document.getElementById("nomeModelo").value;
        if (!nomeTreino) {
            alert("Digite o nome do treino!");
            return;
        }

        let ids = [];
        document.querySelectorAll("#dropzone .exercicio").forEach(ex => ids.push(ex.dataset.id));

        if (ids.length === 0) {
            alert("Adicione pelo menos 1 exercício!");
            return;
        }

        alert("Treino salvo: " + nomeTreino + " com exercícios: " + ids.join(", "));
        // Aqui entra o AJAX para salvar no banco
    }
</script>

</body>
</html>
