<?php
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'aluno') {
    header('Location: index.html'); exit;
}
$id_aluno = $_SESSION['id'];

// --- CÁLCULOS PARA OS WIDGETS ---
$primeiro_dia_mes = date('Y-m-01');
$ultimo_dia_mes = date('Y-m-t');

// 1. Total de treinos concluídos no mês
$checkins_mes_stmt = $conexao->prepare("SELECT COUNT(DISTINCT data_checkin) FROM historico_treino WHERE id_aluno = ? AND data_checkin BETWEEN ? AND ?");
$checkins_mes_stmt->bind_param("iss", $id_aluno, $primeiro_dia_mes, $ultimo_dia_mes);
$checkins_mes_stmt->execute();
$sessoes_concluidas = $checkins_mes_stmt->get_result()->fetch_row()[0];
$checkins_mes_stmt->close();

// 2. Total de treinos planeados no mês
$dias_agendados_stmt = $conexao->prepare("SELECT dia_semana FROM treinos WHERE id_aluno = ? AND status = 'ativo'");
$dias_agendados_stmt->bind_param("i", $id_aluno);
$dias_agendados_stmt->execute();
$dias_semana_agendados = array_column($dias_agendados_stmt->get_result()->fetch_all(MYSQLI_ASSOC), 'dia_semana');
$dias_agendados_stmt->close();

$sessoes_planeadas = 0;
$dias_map_num = [ 'Domingo', 'Segunda-feira', 'Terça-feira', 'Quarta-feira', 'Quinta-feira', 'Sexta-feira', 'Sábado' ];
$total_dias_mes = date('t');
for ($dia = 1; $dia <= $total_dias_mes; $dia++) {
    $dia_da_semana_num = date('w', mktime(0,0,0, date('m'), $dia, date('Y')));
    if (in_array($dias_map_num[$dia_da_semana_num], $dias_semana_agendados)) {
        $sessoes_planeadas++;
    }
}
$progresso_geral = ($sessoes_planeadas > 0) ? ($sessoes_concluidas / $sessoes_planeadas) * 100 : 0;

// 3. Engajamento
if ($progresso_geral > 75) {
    $engajamento = "Excelente"; $cor_engajamento = "text-green-400"; $msg_engajamento = "Continue com o ótimo trabalho!";
} elseif ($progresso_geral > 40) {
    $engajamento = "Regular"; $cor_engajamento = "text-yellow-400"; $msg_engajamento = "Você está no caminho certo, não desista!";
} else {
    $engajamento = "Baixo"; $cor_engajamento = "text-red-400"; $msg_engajamento = "Aumente o foco no seu treino! ;)";
}

// 4. Dias consecutivos
$dias_consecutivos = 0;
$checkins_datas_stmt = $conexao->prepare("SELECT DISTINCT data_checkin FROM historico_treino WHERE id_aluno = ? ORDER BY data_checkin DESC");
$checkins_datas_stmt->bind_param("i", $id_aluno);
$checkins_datas_stmt->execute();
$datas_treinadas = array_column($checkins_datas_stmt->get_result()->fetch_all(MYSQLI_ASSOC), 'data_checkin');
$checkins_datas_stmt->close();

if (!empty($datas_treinadas)) {
    $hoje = new DateTime();
    $ontem = (new DateTime())->modify('-1 day');
    $ultima_data_treino = new DateTime($datas_treinadas[0]);

    if ($ultima_data_treino->format('Y-m-d') == $hoje->format('Y-m-d') || $ultima_data_treino->format('Y-m-d') == $ontem->format('Y-m-d')) {
        $dias_consecutivos = 1;
        for ($i = 0; $i < count($datas_treinadas) - 1; $i++) {
            $data1 = new DateTime($datas_treinadas[$i]);
            $data2 = new DateTime($datas_treinadas[$i+1]);
            if ($data1->diff($data2)->days == 1) {
                $dias_consecutivos++;
            } else {
                break;
            }
        }
    }
}

// Visão da Semana
$dias_semana = ['Segunda-feira', 'Terça-feira', 'Quarta-feira', 'Quinta-feira', 'Sexta-feira', 'Sábado', 'Domingo'];
$treinos_semana = [];
foreach ($dias_semana as $dia) {
    $stmt_semana = $conexao->prepare("SELECT musculos_focados, nome_treino FROM treinos WHERE id_aluno = ? AND dia_semana = ? AND status = 'ativo' AND (data_expiracao IS NULL OR data_expiracao >= CURDATE())");
    $stmt_semana->bind_param("is", $id_aluno, $dia);
    $stmt_semana->execute();
    $treino = $stmt_semana->get_result()->fetch_assoc();
    $treinos_semana[$dia] = $treino ? ($treino['musculos_focados'] ?: $treino['nome_treino']) : 'Descanso';
    $stmt_semana->close();
}
?>
<!DOCTYPE html>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Painel do Aluno</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body { background-color: #F8FAFD; color: #000000; }
        .grid-card { background-color: #F2F6FC; }
    </style>
</head>
<body class="pb-20">
    <header class="bg-white shadow-md p-4 flex justify-between items-center">
        <h1 class="text-2xl font-bold text-black">Olá, <?php echo htmlspecialchars(explode(' ', $_SESSION['nome'])[0]); ?></h1>
        <a href="logout.php" class="bg-red-500 hover:bg-red-600 text-white font-bold py-2 px-4 rounded-lg">Sair</a>
    </header>
    <main class="container mx-auto p-4">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
            <div class="bg-white shadow-lg p-6 rounded-lg">
                <h3 class="text-lg font-semibold text-gray-500 mb-2">Progresso Geral do Mês</h3>
                <div class="flex justify-between items-center">
                    <span class="text-5xl font-bold text-indigo-600"><?php echo round($progresso_geral); ?>%</span>
                    <span class="text-lg font-semibold text-gray-800">Sessões: <?php echo $sessoes_concluidas; ?>/<?php echo $sessoes_planeadas; ?></span>
                </div>
                <div class="w-full bg-gray-200 rounded-full h-2.5 mt-4">
                    <div class="bg-indigo-500 h-2.5 rounded-full" style="width: <?php echo $progresso_geral; ?>%"></div>
                </div>
            </div>
            <div class="bg-white shadow-lg p-6 rounded-lg">
                <h3 class="text-lg font-semibold text-gray-500 mb-2">Sua Rotina</h3>
                <div class="flex justify-between items-center">
                    <div>
                        <p class="text-5xl font-bold text-black"><?php echo $dias_consecutivos; ?></p>
                        <p class="text-sm text-gray-500">Dias consecutivos</p>
                    </div>
                    <div>
                        <p class="text-3xl font-bold <?php echo $cor_engajamento; ?>"><?php echo $engajamento; ?></p>
                        <p class="text-sm text-gray-500">Engajamento</p>
                    </div>
                </div>
                <p class="text-center bg-gray-100 text-gray-700 rounded-full py-1 mt-4 text-sm"><?php echo $msg_engajamento; ?></p>
            </div>
        </div>

        
    </main>

    <nav class="fixed bottom-0 left-0 right-0 bg-white border-t border-gray-200 flex justify-around p-4">
        <a href="dashboard_aluno.php" class="flex flex-col items-center text-indigo-600 w-1/3">
            <i class="fas fa-home fa-lg"></i>
            <span class="text-xs mt-3">Início</span>
        </a>
        <a href="treino_do_dia.php" class="flex flex-col items-center text-gray-500 hover:text-indigo-600 w-1/3">
            <i class="fas fa-dumbbell fa-lg"></i>
            <span class="text-xs mt-3">Treino</span>
        </a>
        <a href="perfil_aluno.php" class="flex flex-col items-center text-gray-500 hover:text-indigo-600 w-1/3">
            <i class="fas fa-user fa-lg"></i>
            <span class="text-xs mt-3">Perfil</span>
        </a>
    </nav>
</body>
</html>