<?php
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'personal') {
    header('Location: index.html'); exit;
}
$id_personal = $_SESSION['id'];
$notificacoes_stmt = $conexao->prepare("SELECT COUNT(*) as total_nao_lidas FROM mensagens WHERE id_destinatario = ? AND lida = FALSE");
$notificacoes_stmt->bind_param("i", $id_personal);
$notificacoes_stmt->execute();
$total_nao_lidas = $notificacoes_stmt->get_result()->fetch_assoc()['total_nao_lidas'];
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Painel do Personal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body class="bg-gray-900 text-white">
    <header class="bg-gray-800 shadow-lg">
        <div class="container mx-auto px-6 py-4 flex justify-between items-center">
            <h1 class="text-xl font-bold text-cyan-400">PAINEL PERSONAL</h1>
            <a href="logout.php" class="bg-red-500 hover:bg-red-600 text-white font-bold py-2 px-4 rounded-lg">Sair</a>
        </div>
    </header>
    <main class="container mx-auto px-6 py-8">
        <h2 class="text-3xl font-bold mb-6">Minhas Ferramentas</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-6">
            <a href="gerenciar_meus_alunos.php" class="bg-gray-800 p-6 rounded-lg hover:bg-gray-700"><h3 class="text-xl font-semibold">Gerenciar Alunos</h3></a>
            <a href="gerenciar_modelos.php" class="bg-gray-800 p-6 rounded-lg hover:bg-gray-700"><h3 class="text-xl font-semibold">Meus Modelos</h3></a>
            <a href="gerenciar_treinos.php" class="bg-gray-800 p-6 rounded-lg hover:bg-gray-700"><h3 class="text-xl font-semibold">Montar Treinos</h3></a>
            <a href="progresso_alunos.php" class="bg-gray-800 p-6 rounded-lg hover:bg-gray-700"><h3 class="text-xl font-semibold">Acompanhar Progresso</h3></a>
            <a href="chat/chat_personal.php" class="relative bg-gray-800 p-6 rounded-lg hover:bg-gray-700">
                <h3 class="text-xl font-semibold">Chat com Alunos</h3>
                <?php if ($total_nao_lidas > 0): ?>
                    <div class="absolute top-2 right-2 bg-blue-500 text-white text-xs font-bold rounded-full h-6 w-6 flex items-center justify-center">
                        <?php echo $total_nao_lidas; ?>
                    </div>
                <?php endif; ?>
            </a>
        </div>
    </main>
</body>
</html>