<?php
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || !in_array($_SESSION['tipo'], ['adm', 'personal'])) {
    header('Location: index.html'); exit;
}
$treino_id = isset($_GET['treino_id']) ? (int)$_GET['treino_id'] : 0;
if ($treino_id === 0) die("ID do treino não fornecido.");

$treino_stmt = $conexao->prepare("SELECT * FROM treinos WHERE id = ?");
$treino_stmt->bind_param("i", $treino_id);
$treino_stmt->execute();
$treino = $treino_stmt->get_result()->fetch_assoc();
if (!$treino) die("Treino não encontrado.");

$exercicios_stmt = $conexao->prepare("SELECT te.*, e.nome_exercicio FROM treino_exercicios te JOIN exercicios e ON te.id_exercicio = e.id WHERE te.id_treino = ?");
$exercicios_stmt->bind_param("i", $treino_id);
$exercicios_stmt->execute();
$exercicios_atuais = $exercicios_stmt->get_result()->fetch_all(MYSQLI_ASSOC);

$grupos_musculares_result = $conexao->query("SELECT * FROM grupos_musculares ORDER BY nome");
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Editar Treino</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sortablejs@latest/Sortable.min.js"></script>
    <style>
        .sortable-ghost { opacity: 0.4; background: #2d3748; }
        .exercise-item { cursor: grab; }
    </style>
</head>
<body class="bg-gray-900 text-white">
    <header class="bg-gray-800 p-4 flex justify-between items-center">
        <h1 class="text-xl font-bold">Editar Treino</h1>
        <a href="historico_treinos_aluno.php?aluno_id=<?php echo $treino['id_aluno']; ?>" class="bg-cyan-500 hover:bg-cyan-600 text-gray-900 font-bold py-2 px-4 rounded-lg">Voltar</a>
    </header>
    <main class="p-4">
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 mb-8">
            <div class="lg:col-span-1 bg-gray-800 p-6 rounded-lg">
                <h3 class="text-2xl font-bold mb-4">Biblioteca de Exercícios</h3>
                <select id="filtro-musculo" class="w-full bg-gray-700 rounded p-2 mb-4">
                    <option value="0">Todos os Músculos</option>
                    <?php while($musculo = $grupos_musculares_result->fetch_assoc()): ?>
                        <option value="<?php echo $musculo['id']; ?>"><?php echo htmlspecialchars($musculo['nome']); ?></option>
                    <?php endwhile; ?>
                </select>
                <div id="lista-exercicios-disponiveis" class="space-y-2 h-[500px] overflow-y-auto pr-2"></div>
            </div>
            <div class="lg:col-span-2 bg-gray-800 p-6 rounded-lg">
                <h3 class="text-2xl font-bold mb-4">Editando Treino de <?php echo $treino['dia_semana']; ?></h3>
                <input id="musculos_focados" class="w-full bg-gray-700 rounded p-2 mb-6" type="text" placeholder="Grupos Musculares" value="<?php echo htmlspecialchars($treino['musculos_focados']); ?>">
                <h3 class="text-xl font-bold mb-4">Arraste ou edite os exercícios</h3>
                <div id="lista-treino-editado" class="space-y-4 min-h-[200px] bg-gray-900 p-4 rounded">
                    <?php foreach ($exercicios_atuais as $ex): ?>
                        <div class="bg-cyan-900 p-3 rounded exercise-item" data-id="<?php echo $ex['id_exercicio']; ?>">
                            <div class="flex justify-between items-center">
                                <span class="font-bold"><?php echo htmlspecialchars($ex['nome_exercicio']); ?></span>
                                <button class="remover-ex text-red-500 hover:text-red-400"><i class="fas fa-times-circle"></i></button>
                            </div>
                            <div class="grid grid-cols-3 gap-2 mt-2">
                                <input type="text" class="bg-gray-700 rounded p-1 text-sm" placeholder="Séries" name="series" value="<?php echo htmlspecialchars($ex['series']); ?>">
                                <input type="text" class="bg-gray-700 rounded p-1 text-sm" placeholder="Reps" name="repeticoes" value="<?php echo htmlspecialchars($ex['repeticoes']); ?>">
                                <input type="number" step="0.5" class="bg-gray-700 rounded p-1 text-sm" placeholder="Carga (kg)" name="carga" value="<?php echo htmlspecialchars($ex['carga_inicial']); ?>">
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                <button id="salvar-alteracoes-btn" class="mt-6 w-full bg-green-500 hover:bg-green-600 text-white font-bold py-3 rounded-lg">Salvar Alterações</button>
            </div>
        </div>
    </main>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const listaDisponiveisEl = document.getElementById('lista-exercicios-disponiveis');
    const listaEditadoEl = document.getElementById('lista-treino-editado');
    const filtroMusculoEl = document.getElementById('filtro-musculo');
    const salvarBtn = document.getElementById('salvar-alteracoes-btn');

    async function carregarExercicios(grupoMuscularId = 0) {
        const response = await fetch(`api_exercicios.php?grupo_muscular_id=${grupoMuscularId}`);
        const exercicios = await response.json();
        listaDisponiveisEl.innerHTML = '';
        exercicios.forEach(ex => {
            listaDisponiveisEl.innerHTML += `<div class="bg-gray-700 p-3 rounded exercise-item" data-id="${ex.id}">${ex.nome_exercicio}</div>`;
        });
    }

    new Sortable(listaDisponiveisEl, {
        group: { name: 'shared', pull: 'clone', put: false },
        animation: 150,
        sort: false
    });

    new Sortable(listaEditadoEl, {
        group: 'shared',
        animation: 150,
        onAdd: function (evt) {
            const itemEl = evt.item;
            itemEl.classList.remove('bg-gray-700');
            itemEl.classList.add('bg-cyan-900');
            itemEl.innerHTML = `
                <div class="flex justify-between items-center">
                    <span class="font-bold">${itemEl.textContent.trim()}</span>
                    <button class="remover-ex text-red-500 hover:text-red-400"><i class="fas fa-times-circle"></i></button>
                </div>
                <div class="grid grid-cols-3 gap-2 mt-2">
                    <input type="text" class="bg-gray-700 rounded p-1 text-sm" placeholder="Séries" name="series">
                    <input type="text" class="bg-gray-700 rounded p-1 text-sm" placeholder="Reps" name="repeticoes">
                    <input type="number" step="0.5" class="bg-gray-700 rounded p-1 text-sm" placeholder="Carga (kg)" name="carga">
                </div>
            `;
        }
    });

    filtroMusculoEl.addEventListener('change', () => carregarExercicios(filtroMusculoEl.value));
    listaEditadoEl.addEventListener('click', e => { if (e.target.closest('.remover-ex')) e.target.closest('.exercise-item').remove(); });

    salvarBtn.addEventListener('click', async () => {
        const treinoData = {
            treino_id: <?php echo $treino_id; ?>,
            musculos_focados: document.getElementById('musculos_focados').value,
            exercicios: []
        };
        listaEditadoEl.querySelectorAll('.exercise-item').forEach(item => {
            treinoData.exercicios.push({
                id_exercicio: item.dataset.id,
                series: item.querySelector('input[name="series"]').value,
                repeticoes: item.querySelector('input[name="repeticoes"]').value,
                carga_inicial: item.querySelector('input[name="carga"]').value
            });
        });

        const response = await fetch('salvar_alteracoes_treino.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(treinoData)
        });
        const result = await response.json();
        if (result.success) {
            alert('Treino atualizado com sucesso!');
            window.location.href = 'historico_treinos_aluno.php?aluno_id=<?php echo $treino['id_aluno']; ?>';
        } else {
            alert('Erro ao salvar alterações: ' + result.message);
        }
    });

    carregarExercicios();
});
</script>
</body>
</html>
