<?php
function verificar_e_atribuir_conquistas($id_aluno, $conexao) {
    // 1. Conquista: PRIMEIRO_CHECKIN
    $check1 = $conexao->prepare("SELECT COUNT(*) as total FROM historico_treino WHERE id_aluno = ?");
    $check1->bind_param("i", $id_aluno);
    $check1->execute();
    if ($check1->get_result()->fetch_assoc()['total'] >= 1) {
        atribuir_conquista($id_aluno, 'PRIMEIRO_CHECKIN', $conexao);
    }
    $check1->close();

    // 2. Conquista: DEZ_CHECKINS
    $check2 = $conexao->prepare("SELECT COUNT(DISTINCT DATE(data_checkin), id_treino_exercicio) as total FROM historico_treino WHERE id_aluno = ?");
    $check2->bind_param("i", $id_aluno);
    $check2->execute();
    if ($check2->get_result()->fetch_assoc()['total'] >= 10) {
        atribuir_conquista($id_aluno, 'DEZ_CHECKINS', $conexao);
    }
    $check2->close();
}

function atribuir_conquista($id_aluno, $chave_conquista, $conexao) {
    $get_id_stmt = $conexao->prepare("SELECT id FROM conquistas WHERE chave_desbloqueio = ?");
    $get_id_stmt->bind_param("s", $chave_conquista);
    $get_id_stmt->execute();
    $conquista = $get_id_stmt->get_result()->fetch_assoc();
    if ($conquista) {
        $id_conquista = $conquista['id'];
        $insert_stmt = $conexao->prepare("INSERT IGNORE INTO aluno_conquistas (id_aluno, id_conquista) VALUES (?, ?)");
        $insert_stmt->bind_param("ii", $id_aluno, $id_conquista);
        $insert_stmt->execute();
        $insert_stmt->close();
    }
    $get_id_stmt->close();
}
?>
