<?php
require_once 'config.php';
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Verifica se o usuário está logado e se é um aluno
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'aluno') {
    header('Location: index.html');
    exit;
}

// Verifica se os parâmetros necessários foram passados na URL
if (!isset($_GET['treino_id']) || !isset($_GET['data'])) {
    // Redireciona de volta com uma mensagem de erro (opcional)
    header('Location: treino_do_dia.php?erro=parametros_invalidos');
    exit;
}

$id_aluno = $_SESSION['id'];
$id_treino = filter_var($_GET['treino_id'], FILTER_VALIDATE_INT);
$data_sessao = $_GET['data']; // A data já vem no formato Y-m-d

// Atualiza a sessão de treino no banco de dados, setando a hora_fim
$stmt = $conexao->prepare(
    "UPDATE sessoes_treino 
     SET hora_fim = NOW() 
     WHERE id_aluno = ? AND id_treino = ? AND data_sessao = ? AND hora_fim IS NULL"
);
$stmt->bind_param("iis", $id_aluno, $id_treino, $data_sessao);
$stmt->execute();
$stmt->close();

// Redireciona o usuário de volta para a página de treino do dia
// O "?finalizado=1" é opcional, mas pode ser útil para mostrar uma mensagem de sucesso
header('Location: treino_do_dia.php?finalizado=1');
exit;
?>