<?php
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'personal') {
    header('Location: index.html'); exit;
}
$id_personal = $_SESSION['id'];
$stmt = $conexao->prepare("SELECT id, nome, email FROM usuarios WHERE id_personal = ? ORDER BY nome");
$stmt->bind_param("i", $id_personal);
$stmt->execute();
$result = $stmt->get_result();
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Gerenciar Meus Alunos</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body class="bg-gray-900 text-white">
    <header class="bg-gray-800 p-4 flex justify-between items-center">
        <h1 class="text-xl">Meus Alunos</h1>
        <a href="dashboard_personal.php" class="bg-cyan-500 hover:bg-cyan-600 text-gray-900 font-bold py-2 px-4 rounded-lg">Voltar</a>
    </header>
    <main class="p-4">
        <div class="bg-gray-800 p-6 rounded-lg mb-8">
            <h3 class="text-2xl font-bold mb-4">Cadastrar Novo Aluno</h3>
            <form action="criar_aluno_personal.php" method="POST" class="space-y-4">
                <input type="hidden" name="id_personal" value="<?php echo $id_personal; ?>">
                <input class="w-full bg-gray-700 rounded p-2" type="text" name="nome" placeholder="Nome Completo" required>
                <input class="w-full bg-gray-700 rounded p-2" type="email" name="email" placeholder="Email" required>
                <input class="w-full bg-gray-700 rounded p-2" type="password" name="senha" placeholder="Senha" required>
                <button type="submit" class="w-full bg-cyan-500 hover:bg-cyan-600 text-gray-900 font-bold py-2 px-4 rounded-lg">Cadastrar Aluno</button>
            </form>
        </div>
        <div class="bg-gray-800 p-6 rounded-lg">
            <h3 class="text-2xl font-bold mb-4">Meus Alunos Cadastrados</h3>
            <div class="overflow-x-auto">
                <table class="w-full text-left">
                    <thead class="bg-gray-700">
                        <tr>
                            <th class="p-3">Nome</th>
                            <th class="p-3">Email</th>
                            <th class="p-3 text-center">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while($aluno = $result->fetch_assoc()): ?>
                        <tr class="border-b border-gray-700">
                            <td class="p-3"><?php echo htmlspecialchars($aluno['nome']); ?></td>
                            <td class="p-3"><?php echo htmlspecialchars($aluno['email']); ?></td>
                            <td class="p-3 text-center">
                                <a href="avaliacao_fisica.php?aluno_id=<?php echo $aluno['id']; ?>" class="text-purple-400 hover:text-purple-300 mr-4" title="Avaliação Física">
                                    <i class="fas fa-clipboard-list"></i>
                                </a>
                                <a href="progresso_alunos.php?aluno_id=<?php echo $aluno['id']; ?>" class="text-blue-400 hover:text-blue-300 mr-4" title="Ver Progresso">
                                    <i class="fas fa-chart-line"></i>
                                </a>
                                <a href="historico_treinos_aluno.php?aluno_id=<?php echo $aluno['id']; ?>" class="text-yellow-400 hover:text-yellow-300 mr-4" title="Histórico de Treinos">
                                    <i class="fas fa-history"></i>
                                </a>
                                <a href="gerenciar_treinos.php?aluno_id=<?php echo $aluno['id']; ?>" class="text-green-400 hover:text-green-300" title="Criar Novo Treino">
                                    <i class="fas fa-plus-circle"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>
</body>
</html>