<?php
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'personal') {
    header('Location: index.html'); exit;
}
$id_personal = $_SESSION['id'];
$grupos_musculares_result = $conexao->query("SELECT * FROM grupos_musculares ORDER BY nome");
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Gerenciar Modelos de Treino</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sortablejs@latest/Sortable.min.js"></script>
    <style>
        .sortable-ghost { opacity: 0.4; background: #2d3748; }
        .exercise-item { cursor: grab; }
    </style>
</head>
<body class="bg-gray-900 text-white">
    <header class="bg-gray-800 p-4 flex justify-between items-center">
        <h1 class="text-xl font-bold">Meus Modelos de Treino</h1>
        <a href="dashboard_personal.php" class="bg-cyan-500 hover:bg-cyan-600 text-gray-900 font-bold py-2 px-4 rounded-lg">Voltar</a>
    </header>
    <main class="p-4">
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 mb-8">
            <div class="lg:col-span-1 bg-gray-800 p-6 rounded-lg">
                <h3 class="text-2xl font-bold mb-4">Biblioteca de Exercícios</h3>
                <select id="filtro-musculo" class="w-full bg-gray-700 rounded p-2 mb-4">
                    <option value="0">Todos os Músculos</option>
                    <?php while($musculo = $grupos_musculares_result->fetch_assoc()): ?>
                        <option value="<?php echo $musculo['id']; ?>"><?php echo htmlspecialchars($musculo['nome']); ?></option>
                    <?php endwhile; ?>
                </select>
                <div id="lista-exercicios-disponiveis" class="space-y-2 h-[500px] overflow-y-auto pr-2"></div>
            </div>
            <div class="lg:col-span-2 bg-gray-800 p-6 rounded-lg">
                <h3 class="text-2xl font-bold mb-4">Criar Novo Modelo</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <input id="nome_modelo" class="w-full bg-gray-700 rounded p-2" type="text" placeholder="Nome do Modelo (Ex: Peito e Tríceps)" required>
                    <input id="musculos_focados" class="w-full bg-gray-700 rounded p-2" type="text" placeholder="Grupos Musculares (Ex: Peito, Ombro)">
                </div>
                <h3 class="text-xl font-bold mb-4">Arraste os exercícios aqui</h3>
                <div id="lista-modelo-montado" class="space-y-4 min-h-[200px] bg-gray-900 p-4 rounded"></div>
                <button id="salvar-modelo-btn" class="mt-6 w-full bg-green-500 hover:bg-green-600 text-white font-bold py-3 rounded-lg">Salvar Modelo</button>
            </div>
        </div>
        <div class="bg-gray-800 p-6 rounded-lg">
            <h3 class="text-2xl font-bold mb-4">Modelos Salvos</h3>
            <div id="lista-modelos-salvos" class="space-y-4 max-h-[600px] overflow-y-auto pr-2"></div>
        </div>
    </main>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const listaDisponiveisEl = document.getElementById('lista-exercicios-disponiveis');
    const listaMontadoEl = document.getElementById('lista-modelo-montado');
    const filtroMusculoEl = document.getElementById('filtro-musculo');
    const salvarModeloBtn = document.getElementById('salvar-modelo-btn');
    const listaModelosSalvosEl = document.getElementById('lista-modelos-salvos');

    async function carregarExercicios(grupoMuscularId = 0) {
        const response = await fetch(`api_exercicios.php?grupo_muscular_id=${grupoMuscularId}`);
        const exercicios = await response.json();
        listaDisponiveisEl.innerHTML = '';
        exercicios.forEach(ex => {
            listaDisponiveisEl.innerHTML += `<div class="bg-gray-700 p-3 rounded exercise-item" data-id="${ex.id}">${ex.nome_exercicio}</div>`;
        });
    }

    async function carregarModelos() {
        const response = await fetch('api_get_modelos.php');
        const modelos = await response.json();
        listaModelosSalvosEl.innerHTML = '';
        modelos.forEach(modelo => {
            let exerciciosHtml = '<ul class="list-disc list-inside text-sm text-gray-400 pl-2 mt-2">';
            modelo.exercicios.forEach(ex => {
                exerciciosHtml += `<li>${ex.nome_exercicio} (${ex.series}x${ex.repeticoes})</li>`;
            });
            exerciciosHtml += '</ul>';

            listaModelosSalvosEl.innerHTML += `
                <div class="bg-gray-700 p-3 rounded">
                    <div class="flex justify-between items-center">
                        <span class="font-bold">${modelo.nome_modelo}</span>
                        <button class="remover-modelo text-red-500 hover:text-red-400" data-modelo-id="${modelo.id}"><i class="fas fa-trash"></i></button>
                    </div>
                    ${exerciciosHtml}
                </div>
            `;
        });
    }

    new Sortable(listaDisponiveisEl, { group: { name: 'shared', pull: 'clone', put: false }, animation: 150, sort: false });
    new Sortable(listaMontadoEl, {
        group: 'shared',
        animation: 150,
        onAdd: function (evt) {
            const itemEl = evt.item;
            itemEl.classList.remove('bg-gray-700');
            itemEl.classList.add('bg-cyan-900');
            itemEl.innerHTML = `<div class="flex justify-between items-center"><span class="font-bold">${itemEl.textContent.trim()}</span><button class="remover-ex text-red-500 hover:text-red-400"><i class="fas fa-times-circle"></i></button></div><div class="grid grid-cols-3 gap-2 mt-2"><input type="text" class="bg-gray-700 rounded p-1 text-sm" placeholder="Séries" name="series"><input type="text" class="bg-gray-700 rounded p-1 text-sm" placeholder="Reps" name="repeticoes"><input type="number" step="0.5" class="bg-gray-700 rounded p-1 text-sm" placeholder="Carga (kg)" name="carga"></div>`;
        }
    });

    filtroMusculoEl.addEventListener('change', () => carregarExercicios(filtroMusculoEl.value));
    listaMontadoEl.addEventListener('click', e => { if (e.target.closest('.remover-ex')) e.target.closest('.exercise-item').remove(); });
    
    salvarModeloBtn.addEventListener('click', async () => {
        const modeloData = {
            nome_modelo: document.getElementById('nome_modelo').value,
            musculos_focados: document.getElementById('musculos_focados').value,
            exercicios: []
        };
        if (!modeloData.nome_modelo) { alert('Dê um nome ao modelo.'); return; }
        listaMontadoEl.querySelectorAll('.exercise-item').forEach(item => {
            modeloData.exercicios.push({
                id_exercicio: item.dataset.id,
                series: item.querySelector('input[name="series"]').value,
                repeticoes: item.querySelector('input[name="repeticoes"]').value,
                carga: item.querySelector('input[name="carga"]').value
            });
        });
        const response = await fetch('salvar_modelo.php', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify(modeloData) });
        const result = await response.json();
        if (result.success) {
            alert('Modelo salvo com sucesso!');
            listaMontadoEl.innerHTML = '';
            document.getElementById('nome_modelo').value = '';
            document.getElementById('musculos_focados').value = '';
            carregarModelos();
        } else {
            alert('Erro ao salvar: ' + result.message);
        }
    });

    listaModelosSalvosEl.addEventListener('click', async function(e) {
        const deleteButton = e.target.closest('.remover-modelo');
        if (deleteButton) {
            const modeloId = deleteButton.dataset.modeloId;
            if (confirm('Tem certeza que deseja excluir este modelo?')) {
                const response = await fetch('api_delete_modelo.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ modelo_id: modeloId })
                });
                const result = await response.json();
                if (result.success) {
                    carregarModelos();
                } else {
                    alert('Erro ao excluir modelo: ' + result.message);
                }
            }
        }
    });

    carregarExercicios();
    carregarModelos();
});
</script>
</body>
</html>