<?php
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || !in_array($_SESSION['tipo'], ['adm', 'personal'])) {
    header('Location: index.html'); exit;
}

$id_personal = $_SESSION['id'];
if ($_SESSION['tipo'] == 'adm') {
    $alunos_result = $conexao->query("SELECT id, nome FROM usuarios WHERE tipo = 'aluno' ORDER BY nome");
    $back_link = 'dashboard_adm.php';
} else {
    $stmt_alunos = $conexao->prepare("SELECT id, nome FROM usuarios WHERE tipo = 'aluno' AND id_personal = ? ORDER BY nome");
    $stmt_alunos->bind_param("i", $id_personal);
    $stmt_alunos->execute();
    $alunos_result = $stmt_alunos->get_result();
    $back_link = 'dashboard_personal.php';
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Planeador Semanal</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sortablejs@latest/Sortable.min.js"></script>
    <style>
        .sortable-ghost { opacity: 0.4; background: #2d3748; }
        .modelo-item, .dia-semana-slot { min-height: 100px; }
    </style>
</head>
<body class="bg-gray-900 text-white">
    <header class="bg-gray-800 p-4 flex justify-between items-center">
        <h1 class="text-xl font-bold">Planeador Semanal</h1>
        <a href="<?php echo $back_link; ?>" class="bg-cyan-500 hover:bg-cyan-600 text-gray-900 font-bold py-2 px-4 rounded-lg">Voltar</a>
    </header>
    <main class="p-4">
        <div class="mb-6">
            <label for="aluno-select" class="block mb-2 text-lg font-semibold">Selecione um Aluno:</label>
            <select id="aluno-select" class="w-full bg-gray-700 rounded p-3">
                <option value="">-- Selecione um aluno para começar --</option>
                <?php while($aluno = $alunos_result->fetch_assoc()): ?>
                    <option value="<?php echo $aluno['id']; ?>"><?php echo htmlspecialchars($aluno['nome']); ?></option>
                <?php endwhile; ?>
            </select>
        </div>

        <div id="planeador-container" class="grid grid-cols-1 lg:grid-cols-4 gap-8 hidden">
            <aside class="lg:col-span-1 bg-gray-800 p-4 rounded-lg">
                <h2 class="text-xl font-bold mb-4">Meus Modelos</h2>
                <div id="lista-modelos" class="space-y-3 h-[70vh] overflow-y-auto"></div>
            </aside>
            <section class="lg:col-span-3 bg-gray-800 p-4 rounded-lg">
                <h2 class="text-xl font-bold mb-4">Plano da Semana</h2>
                <div id="semana-grid" class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-7 gap-4"></div>
            </section>
        </div>
    </main>

    <!-- Modal de Personalização -->
    <div id="personalizar-modal" class="fixed inset-0 bg-black bg-opacity-75 flex items-center justify-center hidden z-50 p-4">
        <div class="bg-gray-800 p-8 rounded-lg w-full max-w-2xl max-h-full overflow-y-auto">
            <div class="flex justify-between items-center mb-4">
                <h3 id="modal-title" class="text-2xl font-bold">Personalizar Treino</h3>
                <button id="modal-close" class="text-gray-400 hover:text-white text-3xl">&times;</button>
            </div>
            <form id="personalizar-form">
                <div id="modal-exercicios-container" class="space-y-4"></div>
                <div class="mt-6 flex gap-4">
                    <button type="submit" class="w-full bg-green-500 hover:bg-green-600 text-white font-bold py-3 rounded-lg">Salvar Treino para Aluno</button>
                    <button type="button" id="modal-cancel" class="w-full bg-gray-600 hover:bg-gray-500 text-white font-bold py-3 rounded-lg">Cancelar</button>
                </div>
            </form>
        </div>
    </div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const alunoSelect = document.getElementById('aluno-select');
    const planeadorContainer = document.getElementById('planeador-container');
    const listaModelosEl = document.getElementById('lista-modelos');
    const semanaGridEl = document.getElementById('semana-grid');
    const diasSemana = ['Segunda-feira', 'Terça-feira', 'Quarta-feira', 'Quinta-feira', 'Sexta-feira', 'Sábado', 'Domingo'];
    const modal = document.getElementById('personalizar-modal');
    const modalTitle = document.getElementById('modal-title');
    const modalForm = document.getElementById('personalizar-form');
    const modalExerciciosContainer = document.getElementById('modal-exercicios-container');
    const modalClose = document.getElementById('modal-close');
    const modalCancel = document.getElementById('modal-cancel');

    new Sortable(listaModelosEl, {
        group: { name: 'shared', pull: 'clone', put: false },
        animation: 150,
        sort: false
    });

    async function carregarModelos() {
        const response = await fetch('api_get_modelos.php');
        const modelos = await response.json();
        listaModelosEl.innerHTML = '';
        if (modelos.length > 0) {
            modelos.forEach(modelo => {
                listaModelosEl.innerHTML += `
                    <div class="bg-gray-700 p-3 rounded-lg modelo-item cursor-grab" data-modelo-id="${modelo.id}">
                        <p class="font-bold">${modelo.nome_modelo}</p>
                        <p class="text-sm text-gray-400">${modelo.musculos_focados}</p>
                    </div>
                `;
            });
        } else {
            listaModelosEl.innerHTML = '<p class="text-gray-400">Nenhum modelo criado. Crie um em "Meus Modelos".</p>';
        }
    }

    async function carregarPlanoSemana(alunoId) {
        const response = await fetch(`api_get_treinos_semana.php?aluno_id=${alunoId}`);
        const treinos = await response.json();
        semanaGridEl.innerHTML = '';

        diasSemana.forEach(dia => {
            const treinoDoDia = treinos[dia] || 'Arraste um modelo aqui';
            const corCard = treinos[dia] ? 'bg-indigo-900' : 'bg-gray-700';

            semanaGridEl.innerHTML += `
                <div class="dia-semana-slot p-4 rounded-lg ${corCard}" data-dia="${dia}">
                    <h3 class="font-bold mb-2">${dia}</h3>
                    <div class="treino-info text-sm text-gray-300">${treinoDoDia}</div>
                </div>
            `;
        });

        document.querySelectorAll('.dia-semana-slot').forEach(slot => {
            new Sortable(slot, {
                group: 'shared',
                onAdd: async function(evt) {
                    const itemEl = evt.item;
                    const idModelo = itemEl.dataset.modeloId;
                    const diaSemana = slot.dataset.dia;
                    
                    // Previne que o item duplicado fique na lista
                    itemEl.remove();

                    // Busca detalhes do modelo e abre o modal
                    const response = await fetch(`api_get_modelo_detalhes.php?modelo_id=${idModelo}`);
                    const modelo = await response.json();
                    
                    modalTitle.textContent = `Personalizar "${modelo.info.nome_modelo}" para ${diaSemana}`;
                    modalExerciciosContainer.innerHTML = '';
                    modelo.exercicios.forEach(ex => {
                        modalExerciciosContainer.innerHTML += `
                            <div class="bg-gray-700 p-3 rounded-lg" data-exercicio-id="${ex.id_exercicio}">
                                <p class="font-bold">${ex.nome_exercicio}</p>
                                <div class="grid grid-cols-3 gap-2 mt-2">
                                    <input type="text" value="${ex.series}" class="bg-gray-600 rounded p-1 text-sm" placeholder="Séries">
                                    <input type="text" value="${ex.repeticoes}" class="bg-gray-600 rounded p-1 text-sm" placeholder="Reps">
                                    <input type="number" step="0.5" value="${ex.carga_sugerida}" class="bg-gray-600 rounded p-1 text-sm" placeholder="Carga (kg)">
                                </div>
                            </div>
                        `;
                    });
                    modal.classList.remove('hidden');

                    modalForm.onsubmit = async (e) => {
                        e.preventDefault();
                        const exerciciosPersonalizados = [];
                        modalExerciciosContainer.querySelectorAll('.bg-gray-700').forEach(exEl => {
                            const inputs = exEl.querySelectorAll('input');
                            exerciciosPersonalizados.push({
                                id_exercicio: exEl.dataset.exercicioId,
                                series: inputs[0].value,
                                repeticoes: inputs[1].value,
                                carga_inicial: inputs[2].value
                            });
                        });

                        const atribuirResponse = await fetch('api_atribuir_treino.php', {
                            method: 'POST',
                            headers: { 'Content-Type': 'application/json' },
                            body: JSON.stringify({
                                id_aluno: alunoSelect.value,
                                dia_semana: diaSemana,
                                nome_treino: modelo.info.nome_modelo,
                                musculos_focados: modelo.info.musculos_focados,
                                exercicios: exerciciosPersonalizados
                            })
                        });
                        const result = await atribuirResponse.json();
                        if(result.success) {
                            modal.classList.add('hidden');
                            carregarPlanoSemana(alunoSelect.value);
                        } else {
                            alert('Erro: ' + result.message);
                        }
                    };
                }
            });
        });
    }

    alunoSelect.addEventListener('change', function() {
        const alunoId = this.value;
        if (alunoId) {
            planeadorContainer.classList.remove('hidden');
            carregarModelos();
            carregarPlanoSemana(alunoId);
        } else {
            planeadorContainer.classList.add('hidden');
        }
    });

    modalClose.addEventListener('click', () => modal.classList.add('hidden'));
    modalCancel.addEventListener('click', () => modal.classList.add('hidden'));
});
</script>
</body>
</html>
