<?php
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'adm') {
    header('Location: index.html');
    exit;
}
$result = $conexao->query("SELECT id, nome, email, tipo FROM usuarios ORDER BY nome");
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Gerenciar Usuários</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-900 text-white">
    <header class="bg-gray-800 p-4">
        <h1 class="text-xl">Gerenciar Usuários</h1>
        <a href="dashboard_adm.php">Voltar</a>
    </header>
    <main class="p-4">
        <div class="bg-gray-800 p-4 rounded-lg">
            <h3 class="text-lg">Cadastrar Novo Usuário</h3>
            <form action="criar_usuario.php" method="POST">
                <input type="text" name="nome" placeholder="Nome" required>
                <input type="email" name="email" placeholder="Email" required>
                <input type="password" name="senha" placeholder="Senha" required>
                <select name="tipo">
                    <option value="aluno">Aluno</option>
                    <option value="personal">Personal</option>
                    <option value="adm">Administrador</option>
                </select>
                <button type="submit">Cadastrar</button>
            </form>
        </div>
        <div class="bg-gray-800 p-4 rounded-lg mt-4">
            <h3 class="text-lg">Usuários Cadastrados</h3>
            <table>
                <thead><tr><th>Nome</th><th>Email</th><th>Tipo</th></tr></thead>
                <tbody>
                    <?php while($user = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($user['nome']); ?></td>
                        <td><?php echo htmlspecialchars($user['email']); ?></td>
                        <td><?php echo htmlspecialchars($user['tipo']); ?></td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </main>
</body>
</html>
