<?php
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'aluno') {
    header('Location: index.html'); exit;
}
$id_aluno = $_SESSION['id'];

// Lógica do Calendário
$mes = isset($_GET['mes']) ? (int)$_GET['mes'] : date('m');
$ano = isset($_GET['ano']) ? (int)$_GET['ano'] : date('Y');
$primeiro_dia_timestamp = mktime(0, 0, 0, $mes, 1, $ano);
$nome_mes = ucfirst(strftime('%B', $primeiro_dia_timestamp));
$primeiro_dia_mes_str = date('Y-m-d', $primeiro_dia_timestamp);
$ultimo_dia_mes_str = date('Y-m-t', $primeiro_dia_timestamp);


$checkins_do_mes = [];
$treinos_agendados_no_mes = [];

$checkins_stmt = $conexao->prepare("SELECT DISTINCT data_checkin FROM historico_treino WHERE id_aluno = ? AND data_checkin BETWEEN ? AND ?");
$checkins_stmt->bind_param("iss", $id_aluno, $primeiro_dia_mes_str, $ultimo_dia_mes_str);
$checkins_stmt->execute();
$checkins_result = $checkins_stmt->get_result();
while($row = $checkins_result->fetch_assoc()) {
    $checkins_do_mes[] = $row['data_checkin'];
}
$checkins_stmt->close();

$dias_agendados_stmt = $conexao->prepare("SELECT dia_semana FROM treinos WHERE id_aluno = ? AND status = 'ativo'");
$dias_agendados_stmt->bind_param("i", $id_aluno);
$dias_agendados_stmt->execute();
$dias_agendados_result = $dias_agendados_stmt->get_result();
$dias_semana_agendados = [];
while($row = $dias_agendados_result->fetch_assoc()) {
    $dias_semana_agendados[] = $row['dia_semana'];
}
$dias_agendados_stmt->close();

$dias_map = ['Domingo', 'Segunda-feira', 'Terça-feira', 'Quarta-feira', 'Quinta-feira', 'Sexta-feira', 'Sábado'];
$total_dias_mes = date('t', $primeiro_dia_timestamp);
for ($dia = 1; $dia <= $total_dias_mes; $dia++) {
    $data_atual = date('Y-m-', $primeiro_dia_timestamp) . str_pad($dia, 2, '0', STR_PAD_LEFT);
    $dia_da_semana_num = date('w', strtotime($data_atual));
    $dia_da_semana_nome = $dias_map[$dia_da_semana_num];
    if (in_array($dia_da_semana_nome, $dias_semana_agendados)) {
        $treinos_agendados_no_mes[] = $data_atual;
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Histórico de Treinos</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body class="bg-gray-900 text-white">
    <header class="bg-gray-800 p-4 flex justify-between items-center">
        <h1 class="text-xl font-bold">Meu Histórico de Treinos</h1>
        <a href="dashboard_aluno.php" class="bg-cyan-500 hover:bg-cyan-600 text-gray-900 font-bold py-2 px-4 rounded-lg">Voltar</a>
    </header>
    <main class="p-4">
        <div class="bg-gray-800 p-6 rounded-lg">
            <div class="flex justify-between items-center mb-4">
                <a href="?mes=<?php echo date('m', strtotime('-1 month', $primeiro_dia_timestamp)); ?>&ano=<?php echo date('Y', strtotime('-1 month', $primeiro_dia_timestamp)); ?>" class="p-2 rounded-lg hover:bg-gray-700"><i class="fas fa-chevron-left"></i></a>
                <h2 class="text-2xl font-bold"><?php echo $nome_mes . ' ' . $ano; ?></h2>
                <a href="?mes=<?php echo date('m', strtotime('+1 month', $primeiro_dia_timestamp)); ?>&ano=<?php echo date('Y', strtotime('+1 month', $primeiro_dia_timestamp)); ?>" class="p-2 rounded-lg hover:bg-gray-700"><i class="fas fa-chevron-right"></i></a>
            </div>
            <div class="grid grid-cols-7 gap-2 text-center">
                <?php $dias_semana_header = ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sáb']; ?>
                <?php foreach($dias_semana_header as $d): ?>
                    <div class="font-bold text-cyan-400"><?php echo $d; ?></div>
                <?php endforeach; ?>
                
                <?php
                $primeiro_dia_semana = date('w', $primeiro_dia_timestamp);
                for ($i = 0; $i < $primeiro_dia_semana; $i++) { echo '<div></div>'; }

                for ($dia = 1; $dia <= $total_dias_mes; $dia++) {
                    $data_completa = date('Y-m-', $primeiro_dia_timestamp) . str_pad($dia, 2, '0', STR_PAD_LEFT);
                    $cor_fundo = 'bg-gray-700';
                    $clickable = '';
                    if (in_array($data_completa, $checkins_do_mes)) {
                        $cor_fundo = 'bg-green-500';
                        $clickable = 'cursor-pointer historico-item';
                    } elseif (in_array($data_completa, $treinos_agendados_no_mes) && $data_completa < date('Y-m-d')) {
                        $cor_fundo = 'bg-red-500';
                        $clickable = 'cursor-pointer historico-item';
                    }
                    echo "<div class='p-3 rounded-lg {$cor_fundo} {$clickable}' data-data-treino='{$data_completa}'>{$dia}</div>";
                }
                ?>
            </div>
        </div>
    </main>

    <!-- Modal de Detalhes -->
    <div id="detalhes-modal" class="fixed inset-0 bg-black bg-opacity-75 flex items-center justify-center hidden z-50 p-4">
        <div class="bg-gray-800 p-8 rounded-lg w-full max-w-lg max-h-full overflow-y-auto">
            <div class="flex justify-between items-center mb-4">
                <h3 id="modal-title" class="text-2xl font-bold">Detalhes do Treino</h3>
                <button id="modal-close" class="text-gray-400 hover:text-white text-3xl">&times;</button>
            </div>
            <div id="modal-content"></div>
        </div>
    </div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const modal = document.getElementById('detalhes-modal');
    const modalTitle = document.getElementById('modal-title');
    const modalContent = document.getElementById('modal-content');
    const modalClose = document.getElementById('modal-close');
    
    document.querySelectorAll('.historico-item').forEach(item => {
        item.addEventListener('click', async function() {
            const dataTreino = this.dataset.dataTreino;
            if (!dataTreino) return;

            const response = await fetch(`api_get_treino_detalhes.php?data=${dataTreino}`);
            const detalhes = await response.json();
            
            modalTitle.innerText = `Treino de ${new Date(dataTreino + 'T00:00:00').toLocaleDateString('pt-BR')}`;
            let contentHtml = '<table class="w-full text-left"><thead><tr class="border-b border-gray-600"><th class="p-2">Exercício</th><th class="p-2">Séries x Reps</th><th class="p-2">Carga Utilizada</th></tr></thead><tbody>';
            if (detalhes.length > 0) {
                detalhes.forEach(ex => {
                    contentHtml += `<tr class="border-b border-gray-700"><td class="p-2">${ex.nome_exercicio}</td><td class="p-2">${ex.series}x${ex.repeticoes}</td><td class="p-2">${ex.carga_utilizada} kg</td></tr>`;
                });
            } else {
                contentHtml += '<tr><td colspan="3" class="p-4 text-center">Nenhum detalhe encontrado para este dia (provavelmente um treino não realizado).</td></tr>';
            }
            contentHtml += '</tbody></table>';
            modalContent.innerHTML = contentHtml;
            modal.classList.remove('hidden');
        });
    });

    modalClose.addEventListener('click', () => modal.classList.add('hidden'));
    modal.addEventListener('click', (e) => {
        if (e.target === modal) {
            modal.classList.add('hidden');
        }
    });
});
</script>
</body>
</html>