<?php
require_once "config.php";
session_start();

if (!isset($_SESSION["id"])) {
    header("Location: login.php");
    exit;
}

$id_aluno = $_SESSION["id"];

// Pega os treinos do aluno
$stmt = $conexao->prepare("SELECT id, nome_treino, dia_semana FROM treinos WHERE id_aluno = ? ORDER BY id DESC");
$stmt->bind_param("i", $id_aluno);
$stmt->execute();
$result = $stmt->get_result();
$treinos = $result->fetch_all(MYSQLI_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Meus Treinos</title>
<style>
body { background:#121212; color:#e0e0e0; font-family: Arial, sans-serif; }
h2 { text-align:center; margin-bottom:20px; }
.container { display:grid; grid-template-columns:repeat(auto-fit, minmax(300px,1fr)); gap:20px; }
.card {
    background:#1e1e2f; padding:20px; border-radius:12px;
    box-shadow:0 4px 10px rgba(0,0,0,0.5); transition:0.2s;
}
.card:hover { transform:translateY(-3px); background:#24243a; }
.card h3 { margin:0 0 10px 0; color:#4CAF50; }
.card small { color:#aaa; }
.ex-list { margin-top:15px; }
.ex-item {
    padding:10px; margin:5px 0; background:#2a2a3b;
    border-radius:6px; font-size:0.9em;
}
.btn {
    display:inline-block; background:#4CAF50; color:white;
    padding:8px 12px; border-radius:6px; text-decoration:none;
    margin-top:10px; transition:0.2s;
}
.btn:hover { background:#45a049; }
.empty { text-align:center; margin-top:30px; font-size:1.1em; color:#aaa; }
</style>
</head>
<body>
<h2>📋 Meus Treinos</h2>

<div class="container">
<?php if ($treinos): ?>
    <?php foreach ($treinos as $treino): ?>
        <div class="card">
            <h3><?= htmlspecialchars($treino['nome_treino']); ?></h3>
            <small>Grupos: <?= htmlspecialchars($treino['dia_semana']); ?></small>

            <div class="ex-list">
                <?php
                $stmt2 = $conexao->prepare("
                    SELECT e.nome_exercicio, e.musculo, te.series, te.repeticoes, te.carga_inicial
                    FROM treino_exercicios te
                    JOIN exercicios e ON te.id_exercicio = e.id
                    WHERE te.id_treino = ?");
                $stmt2->bind_param("i", $treino['id']);
                $stmt2->execute();
                $res2 = $stmt2->get_result();
                if ($res2->num_rows > 0) {
                    while ($ex = $res2->fetch_assoc()) {
                        echo "<div class='ex-item'>
                                <strong>{$ex['nome_exercicio']}</strong> ({$ex['musculo']})<br>
                                Séries: {$ex['series']} | Reps: {$ex['repeticoes']} | Carga: {$ex['carga_inicial']}kg
                              </div>";
                    }
                } else {
                    echo "<p>Nenhum exercício adicionado.</p>";
                }
                ?>
            </div>

            <a class="btn" href="treino_do_dia.php?id=<?= $treino['id']; ?>">▶ Iniciar</a>
        </div>
    <?php endforeach; ?>
<?php else: ?>
    <div class="empty">⚠ Você ainda não criou nenhum treino.</div>
<?php endif; ?>
</div>

</body>
</html>
