<?php
require_once 'config.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = $_POST['email'];
    $senha_digitada = $_POST['senha'];

    // Prepara a consulta para buscar o usuário pelo email
    $stmt = $conexao->prepare("SELECT id, nome, senha, tipo FROM usuarios WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $resultado = $stmt->get_result();

    // Verifica se o usuário existe
    if ($resultado->num_rows == 1) {
        $usuario = $resultado->fetch_assoc();

        // Verifica a senha usando o método seguro de hash
        if (password_verify($senha_digitada, $usuario['senha'])) {
            // Se a senha estiver correta, inicia a sessão
            $_SESSION['loggedin'] = true;
            $_SESSION['id'] = $usuario['id'];
            $_SESSION['nome'] = $usuario['nome'];
            $_SESSION['tipo'] = $usuario['tipo'];

            // Redireciona com base no tipo de usuário
            if ($usuario['tipo'] == 'adm') {
                header("location: dashboard_adm.php");
            } elseif ($usuario['tipo'] == 'personal') {
                header("location: dashboard_personal.php");
            } else {
                header("location: treino_do_dia.php");
            }
            exit;
        }
    }

    // Se o usuário não existir ou a senha estiver incorreta, redireciona com erro
    header("location: index.html?error=Email+ou+senha+inválidos");
    exit;
}
?>
