<?php
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || !in_array($_SESSION['tipo'], ['adm', 'personal'])) {
    header('Location: index.html'); exit;
}

// Lógica para buscar alunos (depende se é adm ou personal)
if ($_SESSION['tipo'] == 'adm') {
    $alunos_result = $conexao->query("SELECT id, nome FROM usuarios WHERE tipo = 'aluno' ORDER BY nome");
    $back_link = 'dashboard_adm.php';
} else {
    $stmt_alunos = $conexao->prepare("SELECT id, nome FROM usuarios WHERE tipo = 'aluno' AND id_personal = ? ORDER BY nome");
    $stmt_alunos->bind_param("i", $_SESSION['id']);
    $stmt_alunos->execute();
    $alunos_result = $stmt_alunos->get_result();
    $back_link = 'dashboard_personal.php';
}

// Buscar grupos musculares para o filtro
$grupos_musculares_result = $conexao->query("SELECT * FROM grupos_musculares ORDER BY nome");
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Montar Treino</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <!-- Biblioteca SortableJS para Drag and Drop -->
    <script src="https://cdn.jsdelivr.net/npm/sortablejs@latest/Sortable.min.js"></script>
    <style>
        .sortable-ghost { opacity: 0.4; background: #2d3748; }
        .exercise-item { cursor: grab; }
    </style>
</head>
<body class="bg-gray-900 text-white">
    <header class="bg-gray-800 p-4 flex justify-between items-center">
        <h1 class="text-xl font-bold">Montador de Treino Interativo</h1>
        <a href="<?php echo $back_link; ?>" class="bg-cyan-500 hover:bg-cyan-600 text-gray-900 font-bold py-2 px-4 rounded-lg">Voltar</a>
    </header>

    <main class="p-4 grid grid-cols-1 lg:grid-cols-3 gap-8">
        <!-- Coluna da Esquerda: Lista de Exercícios -->
        <div class="lg:col-span-1 bg-gray-800 p-6 rounded-lg">
            <h3 class="text-2xl font-bold mb-4">Biblioteca de Exercícios</h3>
            <select id="filtro-musculo" class="w-full bg-gray-700 rounded p-2 mb-4">
                <option value="0">Todos os Músculos</option>
                <?php while($musculo = $grupos_musculares_result->fetch_assoc()): ?>
                    <option value="<?php echo $musculo['id']; ?>"><?php echo htmlspecialchars($musculo['nome']); ?></option>
                <?php endwhile; ?>
            </select>
            <div id="lista-exercicios-disponiveis" class="space-y-2 h-96 overflow-y-auto pr-2">
                <!-- Exercícios serão carregados aqui via JavaScript -->
            </div>
        </div>

        <!-- Coluna da Direita: Montagem do Treino -->
        <div class="lg:col-span-2 bg-gray-800 p-6 rounded-lg">
            <div id="form-treino">
                <h3 class="text-2xl font-bold mb-4">Detalhes do Treino</h3>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-4">
                    <select id="id_aluno" class="w-full bg-gray-700 rounded p-2" required>
                        <option value="">Selecione um aluno</option>
                        <?php while($aluno = $alunos_result->fetch_assoc()): ?>
                            <option value="<?php echo $aluno['id']; ?>"><?php echo htmlspecialchars($aluno['nome']); ?></option>
                        <?php endwhile; ?>
                    </select>
                    <input id="nome_treino" class="w-full bg-gray-700 rounded p-2" type="text" placeholder="Nome do Treino (Ex: Peito e Tríceps)" required>
                    <select id="dia_semana" class="w-full bg-gray-700 rounded p-2" required>
                        <option value="Segunda-feira">Segunda-feira</option>
                        <option value="Terça-feira">Terça-feira</option>
                        <option value="Quarta-feira">Quarta-feira</option>
                        <option value="Quinta-feira">Quinta-feira</option>
                        <option value="Sexta-feira">Sexta-feira</option>
                        <option value="Sábado">Sábado</option>
                        <option value="Domingo">Domingo</option>
                    </select>
                </div>
                 <input id="musculos_focados" class="w-full bg-gray-700 rounded p-2 mb-6" type="text" placeholder="Músculos Focados (Ex: Peito, Ombro, Tríceps)">

                <h3 class="text-xl font-bold mb-4">Arraste os exercícios aqui</h3>
                <div id="lista-treino-montado" class="space-y-4 min-h-[200px] bg-gray-900 p-4 rounded">
                    <!-- Exercícios arrastados aparecerão aqui -->
                </div>
                <button id="salvar-treino" class="mt-6 w-full bg-green-500 hover:bg-green-600 text-white font-bold py-3 px-4 rounded-lg">Salvar Treino Completo</button>
            </div>
        </div>
    </main>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const listaDisponiveisEl = document.getElementById('lista-exercicios-disponiveis');
    const listaMontadoEl = document.getElementById('lista-treino-montado');
    const filtroMusculoEl = document.getElementById('filtro-musculo');
    const salvarTreinoBtn = document.getElementById('salvar-treino');

    // Carrega os exercícios na lista da esquerda
    async function carregarExercicios(grupoMuscularId = 0) {
        const response = await fetch(`api_exercicios.php?grupo_muscular_id=${grupoMuscularId}`);
        const exercicios = await response.json();
        listaDisponiveisEl.innerHTML = '';
        exercicios.forEach(ex => {
            listaDisponiveisEl.innerHTML += `
                <div class="bg-gray-700 p-3 rounded exercise-item" data-id="${ex.id}">
                    ${ex.nome_exercicio}
                </div>
            `;
        });
    }

    // Inicializa as listas com SortableJS
    const sortableDisponiveis = new Sortable(listaDisponiveisEl, {
        group: {
            name: 'shared',
            pull: 'clone', // Clona o item ao arrastar
            put: false
        },
        animation: 150,
        sort: false // Não permite reordenar a lista de origem
    });

    const sortableMontado = new Sortable(listaMontadoEl, {
        group: 'shared',
        animation: 150,
        onAdd: function (evt) {
            const itemEl = evt.item;
            itemEl.classList.remove('bg-gray-700');
            itemEl.classList.add('bg-cyan-900');
            itemEl.innerHTML = `
                <div class="flex justify-between items-center">
                    <span class="font-bold">${itemEl.textContent.trim()}</span>
                    <button class="remover-ex text-red-500 hover:text-red-400"><i class="fas fa-times-circle"></i></button>
                </div>
                <div class="grid grid-cols-3 gap-2 mt-2">
                    <input type="text" class="bg-gray-700 rounded p-1 text-sm" placeholder="Séries" name="series">
                    <input type="text" class="bg-gray-700 rounded p-1 text-sm" placeholder="Reps" name="repeticoes">
                    <input type="number" step="0.5" class="bg-gray-700 rounded p-1 text-sm" placeholder="Carga (kg)" name="carga">
                </div>
            `;
        }
    });

    // Evento para o filtro de músculos
    filtroMusculoEl.addEventListener('change', () => {
        carregarExercicios(filtroMusculoEl.value);
    });

    // Evento para remover um exercício do treino
    listaMontadoEl.addEventListener('click', function(e) {
        if (e.target.closest('.remover-ex')) {
            e.target.closest('.exercise-item').remove();
        }
    });

    // Evento para salvar o treino
    salvarTreinoBtn.addEventListener('click', async function() {
        const treinoData = {
            id_aluno: document.getElementById('id_aluno').value,
            nome_treino: document.getElementById('nome_treino').value,
            dia_semana: document.getElementById('dia_semana').value,
            musculos_focados: document.getElementById('musculos_focados').value,
            exercicios: []
        };

        if (!treinoData.id_aluno || !treinoData.nome_treino) {
            alert('Por favor, preencha o aluno e o nome do treino.');
            return;
        }

        const exerciciosNoTreino = listaMontadoEl.querySelectorAll('.exercise-item');
        exerciciosNoTreino.forEach(item => {
            treinoData.exercicios.push({
                id_exercicio: item.dataset.id,
                series: item.querySelector('input[name="series"]').value,
                repeticoes: item.querySelector('input[name="repeticoes"]').value,
                carga: item.querySelector('input[name="carga"]').value
            });
        });

        const response = await fetch('salvar_treino.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(treinoData)
        });

        const result = await response.json();
        if (result.success) {
            alert('Treino salvo com sucesso!');
            window.location.href = '<?php echo $back_link; ?>';
        } else {
            alert('Erro ao salvar o treino: ' + result.message);
        }
    });

    // Carrega os exercícios iniciais
    carregarExercicios();
});
</script>
</body>
</html>
---
<!-- api_exercicios.php (NOVO ARQUIVO) -->
<?php
header('Content-Type: application/json');
require_once 'config.php';

$grupo_muscular_id = isset($_GET['grupo_muscular_id']) ? (int)$_GET['grupo_muscular_id'] : 0;

if ($grupo_muscular_id > 0) {
    $stmt = $conexao->prepare("
        SELECT e.id, e.nome_exercicio 
        FROM exercicios e
        JOIN exercicio_musculo em ON e.id = em.id_exercicio
        WHERE em.id_grupo_muscular = ?
        ORDER BY e.nome_exercicio
    ");
    $stmt->bind_param("i", $grupo_muscular_id);
} else {
    $stmt = $conexao->prepare("SELECT id, nome_exercicio FROM exercicios ORDER BY nome_exercicio");
}

$stmt->execute();
$result = $stmt->get_result();
$exercicios = $result->fetch_all(MYSQLI_ASSOC);

echo json_encode($exercicios);
$stmt->close();
$conexao->close();
?>
---
<!-- salvar_treino.php (NOVO ARQUIVO) -->
<?php
header('Content-Type: application/json');
require_once 'config.php';

if (!isset($_SESSION['loggedin']) || !in_array($_SESSION['tipo'], ['adm', 'personal'])) {
    echo json_encode(['success' => false, 'message' => 'Acesso não autorizado']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

if (!$data) {
    echo json_encode(['success' => false, 'message' => 'Dados inválidos']);
    exit;
}

// Inicia uma transação para garantir que tudo seja salvo ou nada
$conexao->begin_transaction();

try {
    // 1. Insere o treino principal
    $stmt_treino = $conexao->prepare("INSERT INTO treinos (id_aluno, nome_treino, dia_semana, musculos_focados) VALUES (?, ?, ?, ?)");
    $stmt_treino->bind_param("isss", $data['id_aluno'], $data['nome_treino'], $data['dia_semana'], $data['musculos_focados']);
    $stmt_treino->execute();
    $id_treino = $conexao->insert_id; // Pega o ID do treino que acabamos de criar
    $stmt_treino->close();

    // 2. Insere cada exercício do treino
    $stmt_exercicio = $conexao->prepare("INSERT INTO treino_exercicios (id_treino, id_exercicio, series, repeticoes, carga_inicial) VALUES (?, ?, ?, ?, ?)");
    foreach ($data['exercicios'] as $ex) {
        $stmt_exercicio->bind_param("iissd", $id_treino, $ex['id_exercicio'], $ex['series'], $ex['repeticoes'], $ex['carga']);
        $stmt_exercicio->execute();
    }
    $stmt_exercicio->close();

    // Se tudo deu certo, confirma a transação
    $conexao->commit();
    echo json_encode(['success' => true]);

} catch (mysqli_sql_exception $exception) {
    // Se algo deu errado, desfaz tudo
    $conexao->rollback();
    echo json_encode(['success' => false, 'message' => $exception->getMessage()]);
}

$conexao->close();
?>
---
<!-- dashboard_adm.php e dashboard_personal.php (ATUALIZAÇÃO NECESSÁRIA) -->
<!-- Nestes dois arquivos, você precisa encontrar a linha que tem o link para "gerenciar_treinos.php" -->
<!-- e trocar o link para "montar_treino.php". -->

<!-- Exemplo de como deve ficar o link: -->
<a href="montar_treino.php" class="bg-gray-800 p-6 rounded-lg hover:bg-gray-700">
    <h3 class="text-xl font-semibold">Montar Treinos</h3>
    <p class="text-gray-400">Usar a nova interface interativa.</p>
</a>
