<?php
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'aluno') {
    header('Location: index.html'); exit;
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Meu Perfil</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
 
</head>
<body class="bg-gray-900 text-white pb-20">
    <header class="bg-white shadow-md p-4 flex justify-between items-center">
        <h1 class="text-2xl font-bold text-black">Ol, <?php echo htmlspecialchars(explode(' ', $_SESSION['nome'])[0]); ?></h1>
        <a href="javascript:history.back()" class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded-lg">Voltar</a>
    </header>
    <main class="container mx-auto p-4 space-y-6">
        
        <div class="grid grid-cols-2 md:grid-cols-2 gap-2">
            
            <a href="progresso_aluno_pessoal.php" class="bg-gray-800 p-6 rounded-lg text-center hover:bg-gray-700">
                <i class="fas fa-chart-line fa-3x text-indigo-400 mb-2"></i>
                <h3 class="text-xl font-semibold">Meu Progresso</h3>
            </a>
            
            <a href="conquistas_aluno.php" class="bg-gray-800 p-6 rounded-lg text-center hover:bg-gray-700">
                <i class="fas fa-trophy fa-3x text-yellow-400 mb-2"></i>
                <h3 class="text-xl font-semibold">Conquistas</h3>
            </a>
            <a href="chat/chat_aluno.php" class="bg-gray-800 p-6 rounded-lg text-center hover:bg-gray-700">
                <i class="fas fa-comments fa-3x text-indigo-400 mb-2"></i>
                <h3 class="text-xl font-semibold">Chat com Personal</h3>
            </a>
            <a href="cardio/cardio_hiit.php" class="bg-gray-800 p-6 rounded-lg text-center hover:bg-gray-700">
                <i class="fas fa-heartbeat fa-3x text-red-400 mb-2"></i>
                <h3 class="text-xl font-semibold">Cardio HIIT</h3>
            </a>
            <a href="cardio/cardio_livre.php" class="bg-gray-800 p-6 rounded-lg text-center hover:bg-gray-700">
                <i class="fas fa-running fa-3x text-green-400 mb-2"></i>
                <h3 class="text-xl font-semibold">Cardio Livre</h3>
            </a>
            <a href="cardio/historico_cardio.php" class="bg-gray-800 p-6 rounded-lg text-center hover:bg-gray-700">
                <i class="fas fa-history fa-3x text-blue-400 mb-2"></i>
                <h3 class="text-xl font-semibold">Historico de Cardio</h3>
            </a>
            <a href="listar_treinos_aluno.php" class="bg-gray-800 p-6 rounded-lg text-center hover:bg-gray-700">
                <i class="fas fa-history fa-3x text-blue-400 mb-2"></i>
                <h3 class="text-xl font-semibold">Ver todos os treinos</h3>
            </a>

        </div>
    </main>
    
    <nav class="fixed bottom-0 left-0 right-0 bg-white border-t border-gray-200 flex justify-around p-4">
        <a href="dashboard_aluno.php" class="flex flex-col items-center text-gray-400 hover:text-indigo-400 w-1/3"><i class="fas fa-home fa-lg"></i><span class="text-xs mt-3">Incio</span></a>
        <a href="treino_do_dia.php" class="flex flex-col items-center text-gray-400 hover:text-indigo-400 w-1/3"><i class="fas fa-dumbbell fa-lg"></i><span class="text-xs mt-3">Treino</span></a>
        <a href="perfil_aluno.php" class="flex flex-col items-center text-indigo-400 w-1/3"><i class="fas fa-user fa-lg"></i><span class="text-xs mt-3">Perfil</span></a>
    </nav>
</body>
</html>