<?php
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'aluno') {
    header('Location: index.html'); exit;
}
$id_aluno = $_SESSION['id'];

// Lógica do Calendário
$mes = isset($_GET['mes']) ? (int)$_GET['mes'] : date('m');
$ano = isset($_GET['ano']) ? (int)$_GET['ano'] : date('Y');
$primeiro_dia_timestamp = mktime(0, 0, 0, $mes, 1, $ano);
$meses_map = ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'];
$nome_mes = $meses_map[date('n', $primeiro_dia_timestamp) - 1];
$primeiro_dia_mes_str = date('Y-m-d', $primeiro_dia_timestamp);
$ultimo_dia_mes_str = date('Y-m-t', $primeiro_dia_timestamp);

$checkins_do_mes = [];
$treinos_agendados_no_mes = [];

$checkins_stmt = $conexao->prepare("SELECT DISTINCT data_checkin FROM historico_treino WHERE id_aluno = ? AND data_checkin BETWEEN ? AND ?");
$checkins_stmt->bind_param("iss", $id_aluno, $primeiro_dia_mes_str, $ultimo_dia_mes_str);
$checkins_stmt->execute();
$checkins_result = $checkins_stmt->get_result();
while($row = $checkins_result->fetch_assoc()) {
    $checkins_do_mes[] = $row['data_checkin'];
}
$total_checkins = count($checkins_do_mes);
$checkins_stmt->close();

$dias_agendados_stmt = $conexao->prepare("SELECT dia_semana FROM treinos WHERE id_aluno = ? AND status = 'ativo'");
$dias_agendados_stmt->bind_param("i", $id_aluno);
$dias_agendados_stmt->execute();
$dias_agendados_result = $dias_agendados_stmt->get_result();
$dias_semana_agendados = [];
while($row = $dias_agendados_result->fetch_assoc()) {
    $dias_semana_agendados[] = $row['dia_semana'];
}
$dias_agendados_stmt->close();

$dias_map = ['Domingo', 'Segunda-feira', 'Terça-feira', 'Quarta-feira', 'Quinta-feira', 'Sexta-feira', 'Sábado'];
$total_dias_mes = date('t', $primeiro_dia_timestamp);
for ($dia = 1; $dia <= $total_dias_mes; $dia++) {
    $data_atual = date('Y-m-', $primeiro_dia_timestamp) . str_pad($dia, 2, '0', STR_PAD_LEFT);
    $dia_da_semana_num = date('w', strtotime($data_atual));
    $dia_da_semana_nome = $dias_map[$dia_da_semana_num];
    if (in_array($dia_da_semana_nome, $dias_semana_agendados)) {
        $treinos_agendados_no_mes[] = $data_atual;
    }
}

// Busca exercícios com histórico para o gráfico
$exercicios_query = $conexao->prepare("SELECT DISTINCT e.id, e.nome_exercicio FROM exercicios e JOIN treino_exercicios te ON e.id = te.id_exercicio JOIN historico_treino ht ON te.id = ht.id_treino_exercicio WHERE ht.id_aluno = ? ORDER BY e.nome_exercicio");
$exercicios_query->bind_param("i", $id_aluno);
$exercicios_query->execute();
$exercicios_result = $exercicios_query->get_result();

// Busca todos os planos de treino do aluno
$treinos_query = $conexao->prepare("
    SELECT 
        t.id as treino_id, t.nome_treino, t.dia_semana, t.musculos_focados, t.status
    FROM treinos t
    WHERE t.id_aluno = ?
    ORDER BY FIELD(t.dia_semana, 'Segunda-feira', 'Terça-feira', 'Quarta-feira', 'Quinta-feira', 'Sexta-feira', 'Sábado', 'Domingo'), t.data_criacao DESC
");
$treinos_query->bind_param("i", $id_aluno);
$treinos_query->execute();
$result = $treinos_query->get_result();
$treinos_formatados = [];
while ($row = $result->fetch_assoc()) {
    $treinos_formatados[$row['treino_id']]['info'] = $row;
    $exercicios_hist_query = $conexao->prepare("
        SELECT
            e.nome_exercicio, te.carga_inicial,
            (SELECT ht.carga_utilizada 
             FROM historico_treino ht 
             WHERE ht.id_treino_exercicio = te.id 
             ORDER BY ht.data_checkin DESC, ht.id DESC 
             LIMIT 1) as ultima_carga
        FROM treino_exercicios te
        JOIN exercicios e ON te.id_exercicio = e.id
        WHERE te.id_treino = ?
    ");
    $exercicios_hist_query->bind_param("i", $row['treino_id']);
    $exercicios_hist_query->execute();
    $treinos_formatados[$row['treino_id']]['exercicios'] = $exercicios_hist_query->get_result()->fetch_all(MYSQLI_ASSOC);
    $exercicios_hist_query->close();
}
$treinos_query->close();
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Meu Progresso</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body { background-color: #F8FAFD; color: #000000; }
    </style>
</head>
<body class="pb-20">
    <header class="bg-white shadow-md p-4">
        <h1 class="text-2xl font-bold text-center text-black">Meu Progresso</h1>
    </header>
    <main class="p-4 space-y-8">
        <div class="bg-white shadow-lg p-6 rounded-lg">
            <div class="text-center mb-4">
                <p class="text-lg font-semibold text-gray-500">Check-ins neste mês</p>
                <p class="text-5xl font-bold text-indigo-600"><?php echo $total_checkins; ?></p>
            </div>
            <div class="flex justify-between items-center mb-4">
                <a href="?mes=<?php echo date('m', strtotime('-1 month', $primeiro_dia_timestamp)); ?>&ano=<?php echo date('Y', strtotime('-1 month', $primeiro_dia_timestamp)); ?>" class="p-2 rounded-lg hover:bg-gray-100"><i class="fas fa-chevron-left"></i></a>
                <h2 class="text-2xl font-bold text-black"><?php echo $nome_mes . ' ' . $ano; ?></h2>
                <a href="?mes=<?php echo date('m', strtotime('+1 month', $primeiro_dia_timestamp)); ?>&ano=<?php echo date('Y', strtotime('+1 month', $primeiro_dia_timestamp)); ?>" class="p-2 rounded-lg hover:bg-gray-100"><i class="fas fa-chevron-right"></i></a>
            </div>
            <div class="grid grid-cols-7 gap-1 md:gap-2 text-center">
                <?php $dias_semana_header = ['D', 'S', 'T', 'Q', 'Q', 'S', 'S']; foreach($dias_semana_header as $d) echo "<div class='font-bold text-indigo-600 text-sm'>$d</div>"; ?>
                <?php
                $primeiro_dia_semana = date('w', $primeiro_dia_timestamp);
                for ($i = 0; $i < $primeiro_dia_semana; $i++) { echo '<div></div>'; }
                for ($dia = 1; $dia <= $total_dias_mes; $dia++) {
                    $data_completa = date('Y-m-', $primeiro_dia_timestamp) . str_pad($dia, 2, '0', STR_PAD_LEFT);
                    $cor_fundo = 'bg-gray-200';
                    $clickable = '';
                    if (in_array($data_completa, $checkins_do_mes)) {
                        $cor_fundo = 'bg-green-500 text-white';
                        $clickable = 'cursor-pointer historico-item';
                    } elseif (in_array($data_completa, $treinos_agendados_no_mes) && $data_completa < date('Y-m-d')) {
                        $cor_fundo = 'bg-red-500 text-white';
                        $clickable = 'cursor-pointer historico-item';
                    }
                    echo "<div class='p-2 md:p-3 text-sm md:text-base rounded-lg {$cor_fundo} {$clickable}' data-data-treino='{$data_completa}'>{$dia}</div>";
                }
                ?>
            </div>
        </div>
        <div class="bg-white shadow-lg p-6 rounded-lg">
            <h2 class="text-2xl font-bold mb-4 text-black">Evolução de Carga</h2>
            <select id="exercicio-select" class="w-full bg-gray-100 border border-gray-300 text-black rounded p-2 mb-4">
                <?php if ($exercicios_result->num_rows > 0): ?>
                    <?php while($exercicio = $exercicios_result->fetch_assoc()): ?>
                        <option value="<?php echo $exercicio['id']; ?>"><?php echo htmlspecialchars($exercicio['nome_exercicio']); ?></option>
                    <?php endwhile; ?>
                <?php else: ?>
                    <option value="">Nenhum exercício com registro encontrado</option>
                <?php endif; ?>
            </select>
            <div class="relative h-96">
                <canvas id="evolutionChart"></canvas>
            </div>
        </div>
        <div class="bg-white shadow-lg p-6 rounded-lg">
            <h2 class="text-2xl font-bold mb-4 text-black">Meus Planos de Treino</h2>
            <div class="space-y-4 max-h-[600px] overflow-y-auto pr-2">
                <?php if (empty($treinos_formatados)): ?>
                    <p class="text-center text-gray-500">Nenhum plano de treino encontrado.</p>
                <?php else: ?>
                    <?php foreach ($treinos_formatados as $treino_id => $treino_data): ?>
                        <?php $treino = $treino_data['info']; $isAtivo = $treino['status'] === 'ativo'; ?>
                        <div class="bg-gray-50 p-3 rounded-lg border border-gray-200">
                            <div class="flex justify-between items-center">
                                <span class="font-bold text-black"><?php echo htmlspecialchars($treino['musculos_focados'] ?: $treino['nome_treino']); ?> (<?php echo $treino['dia_semana']; ?>)</span>
                                <span class="px-2 py-1 text-xs font-semibold rounded-full <?php echo $isAtivo ? 'bg-green-100 text-green-800' : 'bg-gray-200 text-gray-600'; ?>">
                                    <?php echo ucfirst($treino['status']); ?>
                                </span>
                            </div>
                            <div class="mt-2 space-y-2 md:hidden"> <!-- Layout para telemóvel -->
                                <?php if (!empty($treino_data['exercicios'])): ?>
                                    <?php foreach ($treino_data['exercicios'] as $ex): ?>
                                        <div class="text-sm border-t border-gray-200 pt-2">
                                            <p class="font-semibold text-black"><?php echo htmlspecialchars($ex['nome_exercicio']); ?></p>
                                            <div class="flex justify-between text-gray-500">
                                                <span>Carga Inicial:</span>
                                                <span><?php echo htmlspecialchars($ex['carga_inicial'] ?? 'N/A'); ?> kg</span>
                                            </div>
                                            <div class="flex justify-between text-gray-500">
                                                <span>Última Carga:</span>
                                                <span><?php echo $ex['ultima_carga'] ? htmlspecialchars($ex['ultima_carga']) . ' kg' : 'Nenhum check-in'; ?></span>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <p class="text-center text-gray-500 text-sm pt-2">Nenhum exercício cadastrado.</p>
                                <?php endif; ?>
                            </div>
                            <table class="w-full text-left text-sm mt-2 hidden md:table"> <!-- Layout para ecrãs maiores -->
                                <thead class="bg-gray-100"><tr><th class="p-2 font-semibold text-gray-700">Exercício</th><th class="p-2 font-semibold text-gray-700">Carga Inicial</th><th class="p-2 font-semibold text-gray-700">Última Carga</th></tr></thead>
                                <tbody>
                                    <?php if (!empty($treino_data['exercicios'])): ?>
                                        <?php foreach ($treino_data['exercicios'] as $ex): ?>
                                            <tr class="border-b border-gray-200">
                                                <td class="p-2 text-black"><?php echo htmlspecialchars($ex['nome_exercicio']); ?></td>
                                                <td class="p-2 text-gray-600"><?php echo htmlspecialchars($ex['carga_inicial'] ?? 'N/A'); ?> kg</td>
                                                <td class="p-2 text-gray-600"><?php echo $ex['ultima_carga'] ? htmlspecialchars($ex['ultima_carga']) . ' kg' : 'Nenhum check-in'; ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr><td colspan="3" class="p-2 text-center text-gray-500">Nenhum exercício cadastrado.</td></tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </main>
    <div id="detalhes-modal" class="fixed inset-0 bg-black bg-opacity-75 flex items-center justify-center hidden z-50 p-4">
        <div class="bg-white p-8 rounded-lg w-full max-w-lg max-h-full overflow-y-auto text-black">
            <div class="flex justify-between items-center mb-4">
                <h3 id="modal-title" class="text-2xl font-bold">Detalhes do Treino</h3>
                <button id="modal-close" class="text-gray-500 hover:text-black text-3xl">&times;</button>
            </div>
            <div id="modal-content"></div>
        </div>
    </div>
    <nav class="fixed bottom-0 left-0 right-0 bg-white border-t border-gray-200 flex justify-around p-2">
        <a href="dashboard_aluno.php" class="flex flex-col items-center text-gray-500 hover:text-indigo-600 w-1/3"><i class="fas fa-home fa-lg"></i><span class="text-xs mt-1">Início</span></a>
        <a href="treino_do_dia.php" class="flex flex-col items-center text-gray-500 hover:text-indigo-600 w-1/3"><i class="fas fa-dumbbell fa-lg"></i><span class="text-xs mt-1">Treino</span></a>
        <a href="perfil_aluno.php" class="flex flex-col items-center text-indigo-600 w-1/3"><i class="fas fa-user fa-lg"></i><span class="text-xs mt-1">Perfil</span></a>
    </nav>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const modal = document.getElementById('detalhes-modal');
    const modalTitle = document.getElementById('modal-title');
    const modalContent = document.getElementById('modal-content');
    const modalClose = document.getElementById('modal-close');
    
    document.querySelectorAll('.historico-item').forEach(item => {
        item.addEventListener('click', async function() {
            const dataTreino = this.dataset.dataTreino;
            if (!dataTreino) return;

            const response = await fetch(`api_get_treino_detalhes.php?data=${dataTreino}`);
            const detalhes = await response.json();
            
            modalTitle.innerText = `Treino de ${new Date(dataTreino + 'T00:00:00').toLocaleDateString('pt-BR')}`;
            let contentHtml = `<div class="mb-4"><span class="font-bold">Duração:</span> ${detalhes.duracao || 'Não registada'}</div>`;
            contentHtml += '<table class="w-full text-left"><thead><tr class="border-b border-gray-200"><th class="p-2">Exercício</th><th class="p-2">Séries x Reps</th><th class="p-2">Carga Utilizada</th></tr></thead><tbody>';
            if (detalhes.exercicios && detalhes.exercicios.length > 0) {
                detalhes.exercicios.forEach(ex => {
                    contentHtml += `<tr class="border-b border-gray-200"><td class="p-2">${ex.nome_exercicio}</td><td class="p-2">${ex.series}x${ex.repeticoes}</td><td class="p-2">${ex.carga_utilizada} kg</td></tr>`;
                });
            } else {
                contentHtml += '<tr><td colspan="3" class="p-4 text-center">Nenhum detalhe encontrado para este dia.</td></tr>';
            }
            contentHtml += '</tbody></table>';
            modalContent.innerHTML = contentHtml;
            modal.classList.remove('hidden');
        });
    });

    modalClose.addEventListener('click', () => modal.classList.add('hidden'));
    modal.addEventListener('click', (e) => {
        if (e.target === modal) {
            modal.classList.add('hidden');
        }
    });

    const exerciseSelect = document.getElementById('exercicio-select');
    const chartCanvas = document.getElementById('evolutionChart').getContext('2d');
    let evolutionChart;

    async function updateChart(exerciseId) {
        if (!exerciseId) return;
        const response = await fetch(`api_dados_aluno.php?tipo=evolucao_dados&exercicio_id=${exerciseId}`);
        const data = await response.json();
        const labels = data.map(item => new Date(item.data_checkin).toLocaleDateString('pt-BR'));
        const cargaData = data.map(item => item.carga_utilizada);
        if (evolutionChart) evolutionChart.destroy();
        evolutionChart = new Chart(chartCanvas, {
            type: 'line',
            data: { labels: labels, datasets: [{ label: 'Carga (kg)', data: cargaData, borderColor: '#4f46e5', tension: 0.1 }] },
            options: { maintainAspectRatio: false }
        });
    }
    exerciseSelect.addEventListener('change', (e) => updateChart(e.target.value));
    if (exerciseSelect.value) {
        updateChart(exerciseSelect.value);
    }
});
</script>
</body>
</html>