<?php
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'personal') {
    header('Location: index.html'); exit;
}
$id_personal = $_SESSION['id'];
$alunos_query = $conexao->prepare("SELECT id, nome FROM usuarios WHERE id_personal = ? ORDER BY nome");
$alunos_query->bind_param("i", $id_personal);
$alunos_query->execute();
$alunos_result = $alunos_query->get_result();

$checkins_do_mes = [];
$treinos_agendados_no_mes = [];
$total_checkins = 0;
$aluno_selecionado_id = isset($_GET['aluno_id']) ? (int)$_GET['aluno_id'] : 0;

if ($aluno_selecionado_id > 0) {
    $primeiro_dia_mes = date('Y-m-01');
    $ultimo_dia_mes = date('Y-m-t');

    $checkins_stmt = $conexao->prepare("SELECT DISTINCT data_checkin FROM historico_treino WHERE id_aluno = ? AND data_checkin BETWEEN ? AND ?");
    $checkins_stmt->bind_param("iss", $aluno_selecionado_id, $primeiro_dia_mes, $ultimo_dia_mes);
    $checkins_stmt->execute();
    $checkins_result = $checkins_stmt->get_result();
    while($row = $checkins_result->fetch_assoc()) {
        $checkins_do_mes[] = $row['data_checkin'];
    }
    $total_checkins = count($checkins_do_mes);
    $checkins_stmt->close();

    $dias_agendados_stmt = $conexao->prepare("SELECT dia_semana FROM treinos WHERE id_aluno = ?");
    $dias_agendados_stmt->bind_param("i", $aluno_selecionado_id);
    $dias_agendados_stmt->execute();
    $dias_agendados_result = $dias_agendados_stmt->get_result();
    $dias_semana_agendados = [];
    while($row = $dias_agendados_result->fetch_assoc()) {
        $dias_semana_agendados[] = $row['dia_semana'];
    }
    $dias_agendados_stmt->close();

    $dias_map = ['Domingo', 'Segunda-feira', 'Terça-feira', 'Quarta-feira', 'Quinta-feira', 'Sexta-feira', 'Sábado'];
    $total_dias_mes = date('t');
    for ($dia = 1; $dia <= $total_dias_mes; $dia++) {
        $data_atual = date('Y-m-') . str_pad($dia, 2, '0', STR_PAD_LEFT);
        $dia_da_semana_num = date('w', strtotime($data_atual));
        $dia_da_semana_nome = $dias_map[$dia_da_semana_num];
        if (in_array($dia_da_semana_nome, $dias_semana_agendados)) {
            $treinos_agendados_no_mes[] = $data_atual;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Progresso dos Alunos</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body class="bg-gray-900 text-white">
    <header class="bg-gray-800 p-4 flex justify-between items-center">
        <h1 class="text-xl">Progresso dos Alunos</h1>
        <a href="dashboard_personal.php" class="bg-cyan-500 hover:bg-cyan-600 text-gray-900 font-bold py-2 px-4 rounded-lg">Voltar</a>
    </header>
    <main class="p-4">
        <div class="bg-gray-800 p-6 rounded-lg">
            <form method="GET" action="progresso_alunos.php">
                <label for="aluno-select" class="block mb-2">Selecione um aluno:</label>
                <select id="aluno-select" name="aluno_id" class="w-full bg-gray-700 rounded p-2" onchange="this.form.submit()">
                    <option value="">-- Selecione --</option>
                    <?php mysqli_data_seek($alunos_result, 0); while($aluno = $alunos_result->fetch_assoc()): ?>
                        <option value="<?php echo $aluno['id']; ?>" <?php if($aluno['id'] == $aluno_selecionado_id) echo 'selected'; ?>>
                            <?php echo htmlspecialchars($aluno['nome']); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </form>
        </div>

        <?php if ($aluno_selecionado_id > 0): ?>
        <div id="graficos-container" class="mt-8 space-y-8">
            <div class="bg-gray-800 p-6 rounded-lg">
                <div class="flex justify-between items-center mb-4">
                    <h2 class="text-2xl font-bold">Constância de Check-ins (<?php echo ucfirst(strftime('%B')); ?>)</h2>
                    <div class="text-lg">Check-ins no mês: <span class="font-bold text-cyan-400"><?php echo $total_checkins; ?></span></div>
                </div>
                <div class="grid grid-cols-7 gap-2 text-center">
                    <?php $dias_semana_header = ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sáb']; foreach($dias_semana_header as $d) echo "<div class='font-bold text-cyan-400'>$d</div>"; ?>
                    <?php $primeiro_dia_semana = date('w', strtotime(date('Y-m-01'))); for ($i = 0; $i < $primeiro_dia_semana; $i++) echo '<div></div>'; for ($dia = 1; $dia <= date('t'); $dia++): $data_completa = date('Y-m-') . str_pad($dia, 2, '0', STR_PAD_LEFT); $cor_fundo = 'bg-gray-700'; if (in_array($data_completa, $checkins_do_mes)) $cor_fundo = 'bg-green-500'; elseif (in_array($data_completa, $treinos_agendados_no_mes) && $data_completa < date('Y-m-d')) $cor_fundo = 'bg-red-500'; echo "<div class='p-3 rounded-lg $cor_fundo'>$dia</div>"; endfor; ?>
                </div>
            </div>
            <div class="bg-gray-800 p-6 rounded-lg">
                <h2 class="text-2xl font-bold mb-4">Evolução de Carga</h2>
                <div id="evolucao-container"></div>
            </div>
        </div>
        <?php endif; ?>
    </main>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const alunoId = '<?php echo $aluno_selecionado_id; ?>';
    if (alunoId > 0) {
        const evolucaoContainer = document.getElementById('evolucao-container');
        let evolutionChart;
        async function renderEvolutionChart() {
            const response = await fetch(`api_dados_progresso.php?aluno_id=${alunoId}&tipo=evolucao_lista`);
            const exercicios = await response.json();
            if (exercicios.length > 0) {
                const selectExercicio = document.createElement('select');
                selectExercicio.className = 'w-full bg-gray-700 rounded p-2 mb-4';
                exercicios.forEach(ex => {
                    const option = document.createElement('option');
                    option.value = ex.id;
                    option.textContent = ex.nome_exercicio;
                    selectExercicio.appendChild(option);
                });
                const chartWrapper = document.createElement('div');
                chartWrapper.className = 'relative h-72';
                const canvas = document.createElement('canvas');
                chartWrapper.appendChild(canvas);
                evolucaoContainer.append(selectExercicio, chartWrapper);
                async function drawChart(exercicioId) {
                    const evolutionResponse = await fetch(`api_dados_progresso.php?aluno_id=${alunoId}&tipo=evolucao_dados&exercicio_id=${exercicioId}`);
                    const data = await evolutionResponse.json();
                    const labels = data.map(item => new Date(item.data_checkin).toLocaleDateString('pt-BR'));
                    const cargaData = data.map(item => item.carga_utilizada);
                    if (evolutionChart) evolutionChart.destroy();
                    evolutionChart = new Chart(canvas.getContext('2d'), {
                        type: 'line',
                        data: { labels: labels, datasets: [{ label: 'Carga (kg)', data: cargaData, borderColor: '#06b6d4', tension: 0.1 }] },
                        options: { maintainAspectRatio: false }
                    });
                }
                selectExercicio.addEventListener('change', (e) => drawChart(e.target.value));
                drawChart(selectExercicio.value);
            } else {
                evolucaoContainer.innerHTML = '<p>Aluno sem registros de carga.</p>';
            }
        }
        renderEvolutionChart();
    }
});
</script>
</body>
</html>