<?php
header('Content-Type: application/json');
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'aluno') {
    http_response_code(403); echo json_encode(['success' => false, 'message' => 'Acesso não autorizado']); exit;
}
$data = json_decode(file_get_contents('php://input'), true);
if (!$data || !isset($data['id_treino_exercicio']) || !isset($data['carga_utilizada'])) { 
    http_response_code(400); echo json_encode(['success' => false, 'message' => 'Dados inválidos']); exit; 
}

$id_treino_exercicio = $data['id_treino_exercicio'];
$id_aluno = $_SESSION['id'];
$carga_utilizada = $data['carga_utilizada'];
$data_checkin = date('Y-m-d');

$stmt = $conexao->prepare("INSERT INTO historico_treino (id_treino_exercicio, id_aluno, carga_utilizada, data_checkin) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE carga_utilizada = VALUES(carga_utilizada)");
$stmt->bind_param("iids", $id_treino_exercicio, $id_aluno, $carga_utilizada, $data_checkin);

if ($stmt->execute()) {
    require_once 'engine_conquistas.php';
    verificar_e_atribuir_conquistas($id_aluno, $conexao);
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => $stmt->error]);
}
$stmt->close();
?>

