<?php
require_once 'config.php';

// Proteção: Apenas para administradores logados
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'adm') {
    die('Você precisa estar logado como Administrador para executar esta ação.');
}

$erros = [];
$sucesso = true;

// Desativa a verificação de chaves estrangeiras para permitir o TRUNCATE
$conexao->query('SET FOREIGN_KEY_CHECKS=0;');

// Limpa as tabelas relacionadas a treinos
if (!$conexao->query('TRUNCATE TABLE historico_treino')) {
    $erros[] = "Erro ao limpar histórico de treinos: " . $conexao->error;
    $sucesso = false;
}
if (!$conexao->query('TRUNCATE TABLE treino_exercicios')) {
    $erros[] = "Erro ao limpar exercícios dos treinos: " . $conexao->error;
    $sucesso = false;
}
if (!$conexao->query('TRUNCATE TABLE treinos')) {
    $erros[] = "Erro ao limpar planos de treino: " . $conexao->error;
    $sucesso = false;
}

// Reativa a verificação de chaves estrangeiras
$conexao->query('SET FOREIGN_KEY_CHECKS=1;');

// Exibe o resultado
echo '<!DOCTYPE html><html lang="pt-br"><head><meta charset="UTF-8"><title>Reset Total de Treinos</title><script src="https://cdn.tailwindcss.com"></script></head><body class="bg-gray-900 text-white flex items-center justify-center min-h-screen">';
echo '<div class="bg-gray-800 p-8 rounded-lg text-center">';

if ($sucesso) {
    echo '<h1 class="text-2xl font-bold text-green-500 mb-4">Reset Total Concluído com Sucesso!</h1>';
    echo '<p>Todas as tabelas de treinos, exercícios de treinos e históricos de check-in foram limpas.</p>';
    echo '<p class="mt-4 font-bold text-yellow-400">IMPORTANTE: Delete este arquivo do servidor agora por segurança.</p>';
} else {
    echo '<h1 class="text-2xl font-bold text-red-500 mb-4">Ocorreu um Erro!</h1>';
    echo '<div class="text-left">';
    foreach ($erros as $erro) {
        echo '<p>' . htmlspecialchars($erro) . '</p>';
    }
    echo '</div>';
}

echo '<a href="dashboard_adm.php" class="mt-6 inline-block bg-cyan-500 hover:bg-cyan-600 text-gray-900 font-bold py-2 px-4 rounded-lg">Voltar ao Painel do Admin</a>';
echo '</div></body></html>';

$conexao->close();
?>