<?php
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'personal') {
    header('Location: index.html'); exit;
}
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $id_aluno = $_POST['id_aluno'];
    $objetivo = $_POST['objetivo'];
    $historico_lesoes = $_POST['historico_lesoes'];
    $medicamentos_uso = $_POST['medicamentos_uso'];
    $frequencia_semanal = $_POST['frequencia_semanal'];
    $observacoes = $_POST['observacoes'];
    $peso_atual = !empty($_POST['peso_atual']) ? $_POST['peso_atual'] : null;
    $altura = !empty($_POST['altura']) ? $_POST['altura'] : null;
    $data_pesagem = !empty($_POST['data_pesagem']) ? $_POST['data_pesagem'] : null;

    $stmt = $conexao->prepare("
        INSERT INTO avaliacoes_fisicas (id_aluno, objetivo, historico_lesoes, medicamentos_uso, frequencia_semanal, observacoes, peso_atual, altura, data_pesagem) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
        ON DUPLICATE KEY UPDATE 
        objetivo = VALUES(objetivo), historico_lesoes = VALUES(historico_lesoes), medicamentos_uso = VALUES(medicamentos_uso), 
        frequencia_semanal = VALUES(frequencia_semanal), observacoes = VALUES(observacoes), peso_atual = VALUES(peso_atual), 
        altura = VALUES(altura), data_pesagem = VALUES(data_pesagem)
    ");
    $stmt->bind_param("isssisdds", $id_aluno, $objetivo, $historico_lesoes, $medicamentos_uso, $frequencia_semanal, $observacoes, $peso_atual, $altura, $data_pesagem);
    $stmt->execute();
    $stmt->close();
}
header("Location: gerenciar_meus_alunos.php?message=Avaliação salva com sucesso!");
exit;
?>