<?php
header('Content-Type: application/json');
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'personal') {
    echo json_encode(['success' => false, 'message' => 'Acesso não autorizado']);
    exit;
}
$data = json_decode(file_get_contents('php://input'), true);
if (!$data || empty($data['nome_modelo']) || empty($data['exercicios'])) {
    echo json_encode(['success' => false, 'message' => 'Dados inválidos']);
    exit;
}
$id_personal = $_SESSION['id'];
$conexao->begin_transaction();
try {
    $stmt_modelo = $conexao->prepare("INSERT INTO treino_modelos (id_personal, nome_modelo, musculos_focados) VALUES (?, ?, ?)");
    $stmt_modelo->bind_param("iss", $id_personal, $data['nome_modelo'], $data['musculos_focados']);
    $stmt_modelo->execute();
    $id_modelo = $conexao->insert_id;
    $stmt_modelo->close();

    $stmt_exercicio = $conexao->prepare("INSERT INTO treino_modelo_exercicios (id_modelo, id_exercicio, series, repeticoes, carga_sugerida) VALUES (?, ?, ?, ?, ?)");
    foreach ($data['exercicios'] as $ex) {
        $stmt_exercicio->bind_param("iissd", $id_modelo, $ex['id_exercicio'], $ex['series'], $ex['repeticoes'], $ex['carga']);
        $stmt_exercicio->execute();
    }
    $stmt_exercicio->close();

    $conexao->commit();
    echo json_encode(['success' => true]);
} catch (mysqli_sql_exception $exception) {
    $conexao->rollback();
    echo json_encode(['success' => false, 'message' => $exception->getMessage()]);
}
$conexao->close();
?>