<?php
header('Content-Type: application/json');
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || !in_array($_SESSION['tipo'], ['adm', 'personal'])) {
    echo json_encode(['success' => false, 'message' => 'Acesso não autorizado']);
    exit;
}
$data = json_decode(file_get_contents('php://input'), true);
if (!$data) {
    echo json_encode(['success' => false, 'message' => 'Dados inválidos']);
    exit;
}
$conexao->begin_transaction();
try {
    $stmt_inativar = $conexao->prepare("UPDATE treinos SET status = 'inativo' WHERE id_aluno = ? AND dia_semana = ?");
    $stmt_inativar->bind_param("is", $data['id_aluno'], $data['dia_semana']);
    $stmt_inativar->execute();
    $stmt_inativar->close();

    $nome_treino = !empty($data['musculos_focados']) ? $data['musculos_focados'] : $data['dia_semana'];
    $data_expiracao = !empty($data['data_expiracao']) ? $data['data_expiracao'] : null;
    
    $stmt_treino = $conexao->prepare("INSERT INTO treinos (id_aluno, nome_treino, dia_semana, musculos_focados, data_expiracao) VALUES (?, ?, ?, ?, ?)");
    $stmt_treino->bind_param("issss", $data['id_aluno'], $nome_treino, $data['dia_semana'], $data['musculos_focados'], $data_expiracao);
    $stmt_treino->execute();
    $id_treino = $conexao->insert_id;
    $stmt_treino->close();

    $stmt_exercicio = $conexao->prepare("INSERT INTO treino_exercicios (id_treino, id_exercicio, series, repeticoes, carga_inicial, tempo_descanso) VALUES (?, ?, ?, ?, ?, ?)");
    foreach ($data['exercicios'] as $ex) {
        $descanso = !empty($ex['descanso']) ? (int)$ex['descanso'] : 60;
        $stmt_exercicio->bind_param("iissdi", $id_treino, $ex['id_exercicio'], $ex['series'], $ex['repeticoes'], $ex['carga'], $descanso);
        $stmt_exercicio->execute();
    }
    $stmt_exercicio->close();

    $conexao->commit();
    echo json_encode(['success' => true]);
} catch (mysqli_sql_exception $exception) {
    $conexao->rollback();
    echo json_encode(['success' => false, 'message' => $exception->getMessage()]);
}
$conexao->close();
?>