<?php
// Este template é incluído pelo 'api_get_treino_por_data.php'
// Ele já tem acesso a variáveis como $treino_principal, $exercicios, $sessao_ativa, $is_today, etc.
?>

<div data-treino-id="<?php echo $treino_principal['id']; ?>">

    <?php if (isset($mensagem_contexto) && !empty($mensagem_contexto)) { echo $mensagem_contexto; } ?>

    <div class="bg-white shadow-lg rounded-lg p-6">
        <div class="flex justify-between items-center mb-4">
            <h2 class="text-xl font-bold text-gray-900 uppercase">
                Foco: <?php echo htmlspecialchars($treino_principal['musculos_focados'] ?: $treino_principal['nome_treino']); ?>
            </h2>
        </div>

        <div class="mb-4">
            <div class="flex justify-between mb-1">
                <span class="text-sm font-medium text-gray-700">Progresso do Treino</span>
                <span class="text-sm font-medium text-gray-700"><?php echo $exercicios_completos; ?> de <?php echo $total_exercicios; ?></span>
            </div>
            <div class="w-full bg-gray-200 rounded-full h-2.5">
                <div class="bg-indigo-500 h-2.5 rounded-full" style="width: <?php echo $progresso_percentual; ?>%"></div>
            </div>
        </div>

        <?php if (!$sessao_ativa && $is_today): ?>
            <button id="iniciar-treino-btn" data-treino-id="<?php echo $treino_principal['id']; ?>" class="w-full bg-indigo-500 hover:bg-indigo-600 text-white font-bold py-3 px-4 rounded-lg flex items-center justify-center transition-colors duration-200">
                <i class="fas fa-play mr-2"></i> Iniciar Treino
            </button>
        <?php endif; ?>
        
        <div id="cronometro-display" class="w-full bg-gray-100 text-gray-800 font-mono text-3xl text-center py-2 px-4 rounded-lg <?php echo $sessao_ativa ? '' : 'hidden'; ?>">
            00:00:00
        </div>
    </div>

    <div class="mt-6 space-y-4">
        <?php foreach ($exercicios as $ex):
            $exercicio_ja_feito = isset($exercicios_finalizados[$ex['id_treino_exercicio']]);
        ?>
            <div class="checkin-form-container bg-white shadow-lg rounded-lg p-4">
                <div class="flex justify-between items-center">
                    <div>
                        <p class="font-bold text-gray-800"><?php echo htmlspecialchars($ex['nome_exercicio']); ?></p>
                        <p class="text-sm text-gray-500">Meta: <?php echo $ex['series']; ?>x <?php echo $ex['repeticoes']; ?> com <?php echo $ex['carga_inicial']; ?>kg</p>
                    </div>

                    <?php if ($exercicio_ja_feito): ?>
                        <div class="text-center">
                             <span class="inline-flex items-center px-3 py-1 bg-green-100 text-green-700 rounded-full text-sm font-semibold">
                                <i class="fas fa-check-circle mr-2"></i>Concluído com <?php echo htmlspecialchars($exercicios_finalizados[$ex['id_treino_exercicio']]); ?>kg
                            </span>
                        </div>
                    <?php elseif ($sessao_ativa): // O formulário só aparece se a sessão estiver ATIVA e o exercício não foi feito ?>
                        <form class="flex items-center gap-2">
                            <input type="hidden" name="id_treino_exercicio" value="<?php echo $ex['id_treino_exercicio']; ?>">
                            <input type="number" step="0.5" name="carga_utilizada" placeholder="Carga (kg)" required class="w-28 bg-gray-100 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-indigo-500 focus:border-indigo-500 p-2">
                            <button type="submit" class="bg-green-500 hover:bg-green-600 text-white font-bold py-2 px-4 rounded-lg">Finalizar</button>
                        </form>
                    <?php endif; ?>
                    
                </div>
            </div>
        <?php endforeach; ?>
    </div>

    <div id="botoes-finais-container"></div>

    <?php if ($is_today && !empty($outros_treinos)): ?>
        <div class="bg-white shadow-lg rounded-lg p-6 mt-8">
            <h3 class="text-xl font-bold text-gray-900 mb-4">Outras Opções de Treino</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <?php foreach($outros_treinos as $outro_treino): ?>
                    <div class="bg-gray-50 flex justify-between items-center p-3 rounded-lg">
                        <span class="font-semibold text-gray-700"><?php echo htmlspecialchars($outro_treino['musculos_focados'] ?: $outro_treino['nome_treino']); ?></span>
                        <button class="outro-treino-btn bg-gray-200 hover:bg-gray-300 text-gray-800 font-semibold py-1 px-3 rounded-lg text-sm" data-treino-id="<?php echo $outro_treino['id']; ?>" data-treino-nome="<?php echo htmlspecialchars($outro_treino['musculos_focados'] ?: $outro_treino['nome_treino']); ?>">
                            Fazer este
                        </button>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>
</div>