<?php
require_once 'config.php';
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'aluno') {
    header('Location: index.html'); exit;
}
$id_aluno = $_SESSION['id'];
$treino_id = isset($_GET['treino_id']) ? (int)$_GET['treino_id'] : 0;
if ($treino_id === 0) { header('Location: dashboard_aluno.php'); exit; }

$treino_stmt = $conexao->prepare("SELECT nome_treino, musculos_focados FROM treinos WHERE id = ? AND id_aluno = ?");
$treino_stmt->bind_param("ii", $treino_id, $id_aluno);
$treino_stmt->execute();
$treino = $treino_stmt->get_result()->fetch_assoc();
if (!$treino) { header('Location: dashboard_aluno.php'); exit; }

$data_hoje = date('Y-m-d');
$sessao_stmt = $conexao->prepare("SELECT TIME_FORMAT(TIMEDIFF(hora_fim, hora_inicio), '%H:%i:%s') as duracao FROM sessoes_treino WHERE id_aluno = ? AND id_treino = ? AND data_sessao = ?");
$sessao_stmt->bind_param("iis", $id_aluno, $treino_id, $data_hoje);
$sessao_stmt->execute();
$sessao = $sessao_stmt->get_result()->fetch_assoc();
$duracao_treino = $sessao['duracao'] ?? 'N/A';
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Treino Concludo!</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
</head>
<body class="bg-gray-900 text-white flex flex-col items-center justify-center min-h-screen p-4">
    <div id="capture" class="bg-gray-800 p-8 rounded-lg shadow-2xl text-center max-w-md w-full">
        <i class="fas fa-check-circle text-green-400 text-6xl mb-4"></i>
        <h1 class="text-3xl font-bold text-white">Parabns!</h1>
        <p class="text-gray-300 mt-2">Voc concluiu o seu treino de hoje.</p>
        <div class="mt-6 text-left bg-gray-700 p-4 rounded-lg">
            <p><span class="font-semibold">Foco do Treino:</span> <?php echo htmlspecialchars($treino['musculos_focados'] ?: $treino['nome_treino']); ?></p>
            <p><span class="font-semibold">Durao:</span> <?php echo htmlspecialchars($duracao_treino); ?></p>
            <p class="mt-2 text-center text-sm text-cyan-400">#UpTrain #Foco #TreinoPago</p>
        </div>
    </div>
    <div class="mt-6 flex gap-4">
        <button id="share-btn" class="bg-gradient-to-r from-purple-500 to-pink-500 text-white font-bold py-3 px-6 rounded-lg flex items-center gap-2">
            <i class="fab fa-instagram"></i> Compartilhar
        </button>
        <a href="dashboard_aluno.php" class="bg-gray-600 hover:bg-gray-500 text-white font-bold py-3 px-6 rounded-lg">Voltar</a>
    </div>

    <!-- Modal de Instrues -->
    <div id="instructions-modal" class="fixed inset-0 bg-black bg-opacity-75 flex items-center justify-center hidden z-50 p-4">
        <div class="bg-gray-700 p-8 rounded-lg text-center">
            <h3 class="text-xl font-bold mb-4">Imagem Salva!</h3>
            <p class="mb-6">A imagem do seu treino foi guardada na sua galeria. Agora, agora s partilhar a sua conquista!</p>
            <button id="modal-close" class="bg-indigo-500 hover:bg-indigo-600 text-white font-bold py-2 px-6 rounded-lg">OK</button>
        </div>
    </div>

<script>
document.getElementById('share-btn').addEventListener('click', function() {
    html2canvas(document.getElementById('capture'), {
        backgroundColor: '#1f2937' // Cor de fundo do body
    }).then(canvas => {
        const image = canvas.toDataURL('image/png');
        const link = document.createElement('a');
        link.href = image;
        link.download = 'treino_concluido_uptrain.png';
        link.click();
        document.getElementById('instructions-modal').classList.remove('hidden');
    });
});

document.getElementById('modal-close').addEventListener('click', function() {
    document.getElementById('instructions-modal').classList.add('hidden');
});
</script>