<?php
require_once 'config.php';
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['loggedin']) || $_SESSION['tipo'] !== 'aluno') {
    header('Location: index.html'); exit;
}
setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'pt', 'portuguese');
?>
<?php
// Adicione este array
$dias_semana_abrev = ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sáb'];
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Treino do Dia</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body class="bg-slate-50 text-black pb-20">

    <header class="bg-white shadow-md p-4 sticky top-0 z-10">
    <h1 class="text-2xl font-bold text-center text-black">Treino do Dia</h1>
    <div class="flex justify-center mt-4 overflow-x-auto whitespace-nowrap">
        <?php
            $dataHoje = new DateTime();
            // Array com os dias da semana abreviados corretamente em UTF-8
            $dias_semana_abrev = ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sáb'];

            for ($i = -1; $i <= 3; $i++):
                $data = new DateTime();
                $data->modify("$i days");
                $is_today = $data->format('Y-m-d') == $dataHoje->format('Y-m-d');
                $cor_fundo = $is_today ? 'bg-indigo-500 text-white' : 'bg-gray-100 text-gray-800';
        ?>
        <div class="text-center p-3 rounded-lg mx-2 cursor-pointer date-selector <?php echo $cor_fundo; ?>" data-date="<?php echo $data->format('Y-m-d'); ?>">
            
            <p class="font-semibold"><?php echo $dias_semana_abrev[$data->format('w')]; ?></p>
            
            <p class="text-sm"><?php echo $data->format('d/m'); ?></p>
        </div>
        <?php endfor; ?>
    </div>
</header>

    <main id="main-content" class="container mx-auto p-4">
        </main>

    <div id="confirm-modal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden z-50 p-4">
        <div class="bg-white shadow-lg p-8 rounded-lg text-center w-full max-w-sm">
            <h3 class="text-xl font-bold mb-4 text-gray-900">Confirmar Treino</h3>
            <p id="modal-text" class="mb-6 text-gray-600"></p>
            <div class="flex justify-center gap-4">
                <button id="confirm-yes" class="bg-green-500 hover:bg-green-600 text-white font-bold py-2 px-6 rounded-lg">Sim</button>
                <button id="confirm-no" class="bg-red-500 hover:bg-red-600 text-white font-bold py-2 px-6 rounded-lg">Cancelar</button>
            </div>
        </div>
    </div>

    <nav class="fixed bottom-0 left-0 right-0 bg-white border-t border-gray-200 flex justify-around p-4">
        <a href="dashboard_aluno.php" class="flex flex-col items-center text-gray-500 hover:text-indigo-600 w-1/3"><i class="fas fa-home fa-lg"></i><span class="text-xs mt-3">Início</span></a>
        <a href="treino_do_dia.php" class="flex flex-col items-center text-indigo-600 w-1/3"><i class="fas fa-dumbbell fa-lg"></i><span class="text-xs mt-3">Treino</span></a>
        <a href="perfil_aluno.php" class="flex flex-col items-center text-gray-500 hover:text-indigo-600 w-1/3"><i class="fas fa-user fa-lg"></i><span class="text-xs mt-3">Perfil</span></a>
    </nav>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const mainContent = document.getElementById('main-content');
    const dateSelectors = document.querySelectorAll('.date-selector');
    const modal = document.getElementById('confirm-modal');
    const confirmYes = document.getElementById('confirm-yes');
    const confirmNo = document.getElementById('confirm-no');
    const modalText = document.getElementById('modal-text');
    let treinoIdParaIniciar = null;
    let timerInterval;

    async function loadTreino(data) {
        if (timerInterval) clearInterval(timerInterval);
        mainContent.innerHTML = '<div class="text-center p-10"><i class="fas fa-spinner fa-spin fa-3x text-indigo-500"></i></div>';
        try {
            const response = await fetch(`api_get_treino_por_data.php?data=${data}`);
            if (!response.ok) {
                throw new Error(`Falha na resposta da rede: Status ${response.status}`);
            }
            const treinoData = await response.json();
            mainContent.innerHTML = treinoData.html;
            initializeTreinoScripts(data, treinoData.sessao_ativa, treinoData.segundos_iniciais);
        } catch (error) {
            mainContent.innerHTML = `<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg text-center" role="alert">
                                        <strong>Erro ao carregar o treino.</strong>
                                        <p class="text-sm mt-2">${error.message}</p>
                                     </div>`;
            console.error('Erro em loadTreino:', error);
        }
    }

    dateSelectors.forEach(selector => {
        selector.addEventListener('click', function() {
            // MUDANÇA: Atualiza as classes de cor para o tema light
            dateSelectors.forEach(s => {
                s.classList.remove('bg-indigo-500', 'text-white');
                s.classList.add('bg-gray-100', 'text-gray-800');
            });
            this.classList.remove('bg-gray-100', 'text-gray-800');
            this.classList.add('bg-indigo-500', 'text-white');
            loadTreino(this.dataset.date);
        });
    });

    function initializeTreinoScripts(dataSelecionada, sessaoAtiva, segundosIniciais = 0) {
        const iniciarBtn = document.getElementById('iniciar-treino-btn');
        const cronometroDisplay = document.getElementById('cronometro-display');
        const botoesFinaisContainer = document.getElementById('botoes-finais-container');
        let segundos = segundosIniciais;

        function formatarTempo(s) {
            const pad = (n) => n.toString().padStart(2, '0');
            const horas = Math.floor(s / 3600);
            const minutos = Math.floor((s % 3600) / 60);
            const segundosRestantes = s % 60;
            return `${pad(horas)}:${pad(minutos)}:${pad(segundosRestantes)}`;
        }

        function iniciarCronometro() {
            if(iniciarBtn) iniciarBtn.classList.add('hidden');
            if(cronometroDisplay) cronometroDisplay.classList.remove('hidden');
            document.querySelectorAll('.checkin-form-container input, .checkin-form-container button').forEach(el => el.disabled = false);
            
            if(cronometroDisplay) cronometroDisplay.textContent = formatarTempo(segundos);

            timerInterval = setInterval(() => {
                segundos++;
                if(cronometroDisplay) cronometroDisplay.textContent = formatarTempo(segundos);
            }, 1000);
            atualizarBotaoFinalizar();
        }

        if (sessaoAtiva) {
            iniciarCronometro();
        }

        if (iniciarBtn) {
            iniciarBtn.addEventListener('click', function() {
                treinoIdParaIniciar = this.dataset.treinoId;
                modalText.textContent = "Deseja realmente iniciar este treino?";
                modal.classList.remove('hidden');
            });
        }
        
        document.querySelectorAll('.outro-treino-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                treinoIdParaIniciar = this.dataset.treinoId;
                modalText.textContent = `Tem certeza que quer fazer o treino de ${this.dataset.treinoNome} hoje?`;
                modal.classList.remove('hidden');
            });
        });

        function atualizarBotaoFinalizar() {
            if(botoesFinaisContainer) {
                const treinoContainer = document.querySelector('[data-treino-id]');
                if (treinoContainer) {
                    const treinoId = treinoContainer.dataset.treinoId;
                    botoesFinaisContainer.innerHTML = `<a href="finalizar_sessao.php?treino_id=${treinoId}&data=${dataSelecionada}" class="block text-center w-full bg-cyan-500 hover:bg-cyan-600 text-white font-bold py-3 rounded-lg mt-6">Finalizar Treino do Dia</a>`;
                }
            }
        }

        document.querySelectorAll('.checkin-form-container form').forEach(form => {
            form.addEventListener('submit', async function(e) {
                e.preventDefault();
                const formData = new FormData(this);
                formData.append('data_checkin', dataSelecionada);
                const data = Object.fromEntries(formData.entries());
                const response = await fetch('registrar_checkin.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify(data)
                });
                const result = await response.json();
                if (result.success) {
                    loadTreino(dataSelecionada);
                } else {
                    alert('Erro ao registrar check-in: ' + result.message);
                }
            });
        });
    }

    confirmYes.addEventListener('click', async () => {
        if(treinoIdParaIniciar) {
            const dataSelecionada = document.querySelector('.date-selector.bg-indigo-500').dataset.date;
            const response = await fetch('api_sessao.php?acao=iniciar', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ treino_id: treinoIdParaIniciar, data_sessao: dataSelecionada })
            });
            const result = await response.json();
            if (result.success) {
                loadTreino(dataSelecionada);
                modal.classList.add('hidden');
            } else {
                alert('Erro ao iniciar a sessão: ' + (result.message || 'Erro desconhecido.'));
            }
        }
    });

    confirmNo.addEventListener('click', () => {
        modal.classList.add('hidden');
    });

    loadTreino('<?php echo date('Y-m-d'); ?>');

    window.addEventListener('pageshow', function(event) {
        if (event.persisted) {
            const dataSelecionada = document.querySelector('.date-selector.bg-indigo-500').dataset.date;
            loadTreino(dataSelecionada);
        }
    });
});
</script>
</body>
</html>